/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.plexus.ComponentLookupManager;
import org.codehaus.plexus.DuplicateChildContainerException;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.component.composition.ComponentComposerManager;
import org.codehaus.plexus.component.composition.CompositionException;
import org.codehaus.plexus.component.composition.setter.SetterComponentComposer;
import org.codehaus.plexus.component.configurator.BasicComponentConfigurator;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.discovery.ComponentDiscovererManager;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryListener;
import org.codehaus.plexus.component.discovery.PlexusXmlComponentDiscoverer;
import org.codehaus.plexus.component.factory.ComponentFactoryManager;
import org.codehaus.plexus.component.manager.ComponentManager;
import org.codehaus.plexus.component.manager.ComponentManagerManager;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRepository;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.component.repository.exception.ComponentRepositoryException;
import org.codehaus.plexus.component.repository.io.PlexusTools;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.configuration.PlexusConfigurationMerger;
import org.codehaus.plexus.configuration.processor.ConfigurationProcessingException;
import org.codehaus.plexus.configuration.processor.ConfigurationProcessor;
import org.codehaus.plexus.configuration.processor.ConfigurationResourceNotFoundException;
import org.codehaus.plexus.configuration.processor.DirectoryConfigurationResourceHandler;
import org.codehaus.plexus.configuration.processor.FileConfigurationResourceHandler;
import org.codehaus.plexus.container.initialization.ComponentDiscoveryPhase;
import org.codehaus.plexus.container.initialization.ContainerInitializationContext;
import org.codehaus.plexus.container.initialization.ContainerInitializationException;
import org.codehaus.plexus.container.initialization.ContainerInitializationPhase;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.context.ContextMapAdapter;
import org.codehaus.plexus.context.DefaultContext;
import org.codehaus.plexus.lifecycle.LifecycleHandlerManager;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;

public class DefaultPlexusContainer
extends AbstractLogEnabled
implements MutablePlexusContainer {
    protected static final String DEFAULT_CONTAINER_NAME = "default";
    protected static final String DEFAULT_REALM_NAME = "plexus.core";
    protected String name;
    protected PlexusContainer parentContainer;
    protected DefaultContext containerContext;
    protected PlexusConfiguration configuration;
    protected Reader configurationReader;
    protected ClassWorld classWorld;
    protected ClassRealm containerRealm;
    protected List initializationPhases;
    protected ComponentRepository componentRepository;
    protected ComponentManagerManager componentManagerManager;
    protected LifecycleHandlerManager lifecycleHandlerManager;
    protected ComponentDiscovererManager componentDiscovererManager;
    protected ComponentFactoryManager componentFactoryManager;
    protected ComponentLookupManager componentLookupManager;
    protected ComponentComposerManager componentComposerManager;
    protected LoggerManager loggerManager;
    protected Map childContainers = new WeakHashMap();
    protected Date creationDate = new Date();
    protected boolean reloadingEnabled;
    private ThreadLocal lookupRealm = new ThreadLocal();
    private ClassRealm staticLookupRealm;
    boolean initialized;

    public ClassRealm setLookupRealm(ClassRealm realm) {
        if (realm == null) {
            return null;
        }
        this.staticLookupRealm = realm;
        ClassRealm oldRealm = (ClassRealm)this.lookupRealm.get();
        this.lookupRealm.set(realm);
        return oldRealm;
    }

    public ClassRealm getLookupRealm() {
        ClassRealm cr = (ClassRealm)this.lookupRealm.get();
        return cr == null ? this.staticLookupRealm : cr;
    }

    public DefaultPlexusContainer() throws PlexusContainerException {
        this.construct(DEFAULT_CONTAINER_NAME, null, null, null, null);
    }

    public DefaultPlexusContainer(String name, Map context) throws PlexusContainerException {
        this.construct(name, context, null, null, null);
    }

    public DefaultPlexusContainer(String name, Map context, ClassWorld classWorld) throws PlexusContainerException {
        this(name, context, classWorld, null);
    }

    public DefaultPlexusContainer(String name, Map context, ClassWorld classWorld, InputStream config) throws PlexusContainerException {
        this.construct(name, context, config, classWorld, null);
    }

    public DefaultPlexusContainer(String name, Map context, File file) throws PlexusContainerException {
        this(name, context, null, DefaultPlexusContainer.toStream(file));
    }

    public DefaultPlexusContainer(String name, Map context, File file, ClassWorld classWorld) throws PlexusContainerException {
        this(name, context, classWorld, DefaultPlexusContainer.toStream(file));
    }

    public DefaultPlexusContainer(String name, Map context, String configurationResource) throws PlexusContainerException {
        this(name, context, null, DefaultPlexusContainer.toStream(configurationResource));
    }

    public DefaultPlexusContainer(String name, Map context, String configurationResource, ClassWorld classWorld) throws PlexusContainerException {
        this(name, context, classWorld, DefaultPlexusContainer.toStream(configurationResource));
    }

    public DefaultPlexusContainer(String name, Map context, URL url) throws PlexusContainerException {
        this(name, context, null, DefaultPlexusContainer.toStream(url));
    }

    public DefaultPlexusContainer(String name, Map context, URL url, ClassWorld classWorld) throws PlexusContainerException {
        this(name, context, classWorld, DefaultPlexusContainer.toStream(url));
    }

    protected DefaultPlexusContainer(String name, Map context, PlexusContainer parent, List discoveryListeners) throws PlexusContainerException {
        this.parentContainer = parent;
        this.loggerManager = this.parentContainer.getLoggerManager();
        this.containerRealm = DefaultPlexusContainer.getChildRealm(this.getName(), name, parent.getContainerRealm());
        Iterator it = discoveryListeners.iterator();
        while (it.hasNext()) {
            this.registerComponentDiscoveryListener((ComponentDiscoveryListener)it.next());
        }
        this.construct(name, context, null, this.containerRealm.getWorld(), this.containerRealm);
    }

    public Object lookup(String componentKey) throws ComponentLookupException {
        return this.lookup(componentKey, this.getLookupRealm());
    }

    public Object lookup(String componentKey, ClassRealm realm) throws ComponentLookupException {
        return this.componentLookupManager.lookup(componentKey, realm);
    }

    public Map lookupMap(String role) throws ComponentLookupException {
        return this.lookupMap(role, this.getLookupRealm());
    }

    public Map lookupMap(String role, ClassRealm realm) throws ComponentLookupException {
        return this.componentLookupManager.lookupMap(role, realm);
    }

    public List lookupList(String role) throws ComponentLookupException {
        return this.lookupList(role, this.getLookupRealm());
    }

    public List lookupList(String role, ClassRealm realm) throws ComponentLookupException {
        return this.componentLookupManager.lookupList(role, realm);
    }

    public Object lookup(String role, String roleHint) throws ComponentLookupException {
        return this.componentLookupManager.lookup(role, roleHint, this.getLookupRealm());
    }

    public Object lookup(String role, String roleHint, ClassRealm realm) throws ComponentLookupException {
        return this.componentLookupManager.lookup(role, roleHint, realm);
    }

    public Object lookup(Class componentClass) throws ComponentLookupException {
        return this.lookup(componentClass, this.getLookupRealm());
    }

    public Object lookup(Class componentClass, ClassRealm realm) throws ComponentLookupException {
        return this.componentLookupManager.lookup(componentClass, realm);
    }

    public Map lookupMap(Class role) throws ComponentLookupException {
        return this.lookupMap(role, this.getLookupRealm());
    }

    public Map lookupMap(Class role, ClassRealm realm) throws ComponentLookupException {
        return this.componentLookupManager.lookupMap(role, realm);
    }

    public List lookupList(Class role) throws ComponentLookupException {
        return this.lookupList(role, this.getLookupRealm());
    }

    public List lookupList(Class role, ClassRealm realm) throws ComponentLookupException {
        return this.componentLookupManager.lookupList(role, realm);
    }

    public Object lookup(Class role, String roleHint) throws ComponentLookupException {
        return this.lookup(role, roleHint, this.getLookupRealm());
    }

    public Object lookup(Class role, String roleHint, ClassRealm realm) throws ComponentLookupException {
        return this.componentLookupManager.lookup(role, roleHint, realm);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public boolean hasChildContainer(String name) {
        return this.childContainers.get(name) != null;
    }

    public void removeChildContainer(String name) {
        this.childContainers.remove(name);
    }

    public PlexusContainer getChildContainer(String name) {
        return (PlexusContainer)this.childContainers.get(name);
    }

    public ClassRealm createComponentRealm(String id, List jars) throws PlexusContainerException {
        try {
            ClassRealm realm = this.classWorld.getRealm(id);
            this.getLogger().warn("Reusing existing component realm: " + id + " - no components detected!", new Throwable());
            return realm;
        }
        catch (NoSuchRealmException e) {
            ClassRealm componentRealm;
            try {
                componentRealm = this.containerRealm.createChildRealm(id);
            }
            catch (DuplicateRealmException e2) {
                throw new PlexusContainerException("Error creating child realm.", e2);
            }
            try {
                Iterator it = jars.iterator();
                while (it.hasNext()) {
                    componentRealm.addURL(((File)it.next()).toURI().toURL());
                }
            }
            catch (MalformedURLException e3) {
                throw new PlexusContainerException("Error adding JARs to realm.", e3);
            }
            this.getLogger().debug("Created component realm: " + id);
            try {
                this.discoverComponents(componentRealm);
            }
            catch (PlexusConfigurationException e4) {
                throw new PlexusContainerException("Error configuring discovered component.", e4);
            }
            catch (ComponentRepositoryException e5) {
                throw new PlexusContainerException("Error resolving discovered component.", e5);
            }
            return componentRealm;
        }
    }

    public PlexusContainer createChildContainer(String name, List classpathJars, Map context) throws PlexusContainerException {
        return this.createChildContainer(name, classpathJars, context, Collections.EMPTY_LIST);
    }

    public PlexusContainer createChildContainer(String name, List classpathJars, Map context, List discoveryListeners) throws PlexusContainerException {
        if (this.hasChildContainer(name)) {
            throw new DuplicateChildContainerException(this.getName(), name);
        }
        DefaultPlexusContainer child = new DefaultPlexusContainer(name, context, this, discoveryListeners);
        this.childContainers.put(name, child);
        return child;
    }

    private static ClassRealm getChildRealm(String parentName, String name, ClassRealm containerRealm) throws PlexusContainerException {
        String childRealmId = parentName + ".child-container[" + name + "]";
        try {
            ClassRealm childRealm = containerRealm.getWorld().getRealm(childRealmId);
            childRealm.setParentRealm(containerRealm);
            return childRealm;
        }
        catch (NoSuchRealmException e) {
            try {
                return containerRealm.createChildRealm(childRealmId);
            }
            catch (DuplicateRealmException impossibleError) {
                throw new PlexusContainerException("Error creating new realm: After getRealm() failed, newRealm() produced duplication error on same id!", impossibleError);
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParentPlexusContainer(PlexusContainer container) {
        this.parentContainer = container;
    }

    public ComponentDescriptor getComponentDescriptor(String role) {
        return this.getComponentDescriptor(role, this.getLookupRealm());
    }

    public ComponentDescriptor getComponentDescriptor(String role, ClassRealm realm) {
        return this.getComponentDescriptor(role, DEFAULT_CONTAINER_NAME, realm);
    }

    public ComponentDescriptor getComponentDescriptor(String role, String hint) {
        return this.getComponentDescriptor(role, hint, this.getLookupRealm());
    }

    public ComponentDescriptor getComponentDescriptor(String role, String hint, ClassRealm classRealm) {
        ComponentDescriptor result = this.componentRepository.getComponentDescriptor(role, hint, classRealm);
        for (ClassRealm tmpRealm = classRealm.getParentRealm(); result == null && tmpRealm != null; tmpRealm = tmpRealm.getParentRealm()) {
            result = this.componentRepository.getComponentDescriptor(role, hint, classRealm);
        }
        if (result == null && this.parentContainer != null) {
            result = this.parentContainer.getComponentDescriptor(role, hint, classRealm);
        }
        return result;
    }

    public Map getComponentDescriptorMap(String role) {
        return this.getComponentDescriptorMap(role, this.getLookupRealm());
    }

    public Map getComponentDescriptorMap(String role, ClassRealm realm) {
        Map componentDescriptors;
        Map m;
        WeakHashMap result = new WeakHashMap();
        if (this.parentContainer != null && (m = this.parentContainer.getComponentDescriptorMap(role, realm)) != null) {
            result.putAll(m);
        }
        if ((componentDescriptors = this.componentRepository.getComponentDescriptorMap(role, realm)) != null) {
            result.putAll(componentDescriptors);
        }
        return result;
    }

    public List getComponentDescriptorList(String role) {
        return this.getComponentDescriptorList(role, this.getLookupRealm());
    }

    public List getComponentDescriptorList(String role, ClassRealm realm) {
        Map componentDescriptors = this.getComponentDescriptorMap(role, realm);
        return new ArrayList(componentDescriptors.values());
    }

    public void addComponentDescriptor(ComponentDescriptor componentDescriptor) throws ComponentRepositoryException {
        this.componentRepository.addComponentDescriptor(componentDescriptor);
    }

    public void release(Object component) throws ComponentLifecycleException {
        if (component == null) {
            return;
        }
        ComponentManager componentManager = this.componentManagerManager.findComponentManagerByComponentInstance(component);
        if (componentManager == null) {
            if (this.parentContainer != null) {
                this.parentContainer.release(component);
            } else {
                this.getLogger().warn("Component manager not found for returned component. Ignored. component=" + component);
            }
        } else {
            componentManager.release(component);
            if (componentManager.getConnections() <= 0) {
                this.componentManagerManager.unassociateComponentWithComponentManager(component);
            }
        }
    }

    public void releaseAll(Map components) throws ComponentLifecycleException {
        Iterator i = components.values().iterator();
        while (i.hasNext()) {
            Object component = i.next();
            this.release(component);
        }
    }

    public void releaseAll(List components) throws ComponentLifecycleException {
        Iterator i = components.iterator();
        while (i.hasNext()) {
            Object component = i.next();
            this.release(component);
        }
    }

    public boolean hasComponent(String componentKey) {
        return this.hasComponent(componentKey, this.getLookupRealm());
    }

    public boolean hasComponent(String componentKey, ClassRealm realm) {
        return this.componentRepository.hasComponent(componentKey, realm);
    }

    public boolean hasComponent(String role, String roleHint) {
        return this.hasComponent(role, roleHint, this.getLookupRealm());
    }

    public boolean hasComponent(String role, String roleHint, ClassRealm realm) {
        return this.componentRepository.hasComponent(role, roleHint, realm);
    }

    public void suspend(Object component) throws ComponentLifecycleException {
        if (component == null) {
            return;
        }
        ComponentManager componentManager = this.componentManagerManager.findComponentManagerByComponentInstance(component);
        componentManager.suspend(component);
    }

    public void resume(Object component) throws ComponentLifecycleException {
        if (component == null) {
            return;
        }
        ComponentManager componentManager = this.componentManagerManager.findComponentManagerByComponentInstance(component);
        componentManager.resume(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void construct(String name, Map context, InputStream in, ClassWorld classWorld, ClassRealm realm) throws PlexusContainerException {
        block9: {
            this.name = name;
            this.classWorld = classWorld;
            if (this.classWorld == null) {
                this.classWorld = new ClassWorld(DEFAULT_REALM_NAME, Thread.currentThread().getContextClassLoader());
            }
            this.containerRealm = realm;
            if (this.containerRealm == null) {
                try {
                    this.containerRealm = this.classWorld.getRealm(DEFAULT_REALM_NAME);
                }
                catch (NoSuchRealmException e) {
                    LinkedList realms = new LinkedList(this.classWorld.getRealms());
                    this.containerRealm = (ClassRealm)realms.get(0);
                    if (this.containerRealm != null) break block9;
                    System.err.println("No container realm! Expect errors.");
                    new Throwable().printStackTrace();
                }
            }
        }
        this.setLookupRealm(this.containerRealm);
        this.containerContext = new DefaultContext();
        if (context != null) {
            Iterator it = context.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                this.addContextValue(entry.getKey(), entry.getValue());
            }
        }
        this.configurationReader = in == null ? null : new InputStreamReader(in);
        try {
            this.initialize();
            this.start();
        }
        finally {
            IOUtil.close((Reader)this.configurationReader);
        }
    }

    protected void initialize() throws PlexusContainerException {
        if (this.initialized) {
            throw new PlexusContainerException("The container has already been initialized!");
        }
        try {
            this.initializeConfiguration();
            this.initializePhases();
        }
        catch (ContextException e) {
            throw new PlexusContainerException("Error processing configuration", e);
        }
        catch (ConfigurationProcessingException e) {
            throw new PlexusContainerException("Error processing configuration", e);
        }
        catch (ConfigurationResourceNotFoundException e) {
            throw new PlexusContainerException("Error processing configuration", e);
        }
        catch (PlexusConfigurationException e) {
            throw new PlexusContainerException("Error configuring components", e);
        }
        this.initialized = true;
    }

    protected void initializePhases() throws PlexusContainerException {
        PlexusConfiguration initializationConfiguration = this.configuration.getChild("container-initialization");
        ContainerInitializationContext initializationContext = new ContainerInitializationContext(this, this.classWorld, this.containerRealm, this.configuration);
        BasicComponentConfigurator c = new BasicComponentConfigurator();
        try {
            c.configureComponent(this, initializationConfiguration, this.containerRealm);
        }
        catch (ComponentConfigurationException e) {
            throw new PlexusContainerException("Error setting container initialization initializationPhases.", e);
        }
        Iterator iterator = this.initializationPhases.iterator();
        while (iterator.hasNext()) {
            ContainerInitializationPhase phase = (ContainerInitializationPhase)iterator.next();
            try {
                phase.execute(initializationContext);
            }
            catch (ContainerInitializationException e) {
                throw new PlexusContainerException("Error initializaing container in " + phase + ".", e);
            }
        }
    }

    public List discoverComponents(ClassRealm classRealm) throws PlexusConfigurationException, ComponentRepositoryException {
        return this.discoverComponents(classRealm, false);
    }

    public List discoverComponents(ClassRealm classRealm, boolean override) throws PlexusConfigurationException, ComponentRepositoryException {
        return ComponentDiscoveryPhase.discoverComponents(this, classRealm, override);
    }

    protected void start() throws PlexusContainerException {
        this.configuration = null;
    }

    public void dispose() {
        this.disposeAllComponents();
        boolean needToDisposeRealm = true;
        if (this.parentContainer != null && this.containerRealm.getId().equals(this.parentContainer.getContainerRealm().getId())) {
            needToDisposeRealm = false;
        }
        if (this.parentContainer != null) {
            this.parentContainer.removeChildContainer(this.getName());
            this.parentContainer = null;
        }
        try {
            this.containerRealm.setParentRealm(null);
            if (needToDisposeRealm) {
                this.classWorld.disposeRealm(this.containerRealm.getId());
            }
        }
        catch (NoSuchRealmException e) {
            this.getLogger().debug("Failed to dispose realm for exiting container: " + this.getName(), e);
        }
    }

    protected void disposeAllComponents() {
        ArrayList collection = new ArrayList(this.componentManagerManager.getComponentManagers().values());
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            try {
                ((ComponentManager)iter.next()).dispose();
            }
            catch (Exception e) {
                this.getLogger().error("Error while disposing component manager. Continuing with the rest", e);
            }
        }
        this.componentManagerManager.getComponentManagers().clear();
    }

    public void addContextValue(Object key, Object value) {
        this.containerContext.put(key, value);
    }

    public String getName() {
        return this.name;
    }

    public ClassWorld getClassWorld() {
        return this.classWorld;
    }

    public void setClassWorld(ClassWorld classWorld) {
        this.classWorld = classWorld;
    }

    public ClassRealm getContainerRealm() {
        return this.containerRealm;
    }

    public void setContainerRealm(ClassRealm containerRealm) {
        this.containerRealm = containerRealm;
    }

    public Context getContext() {
        return this.containerContext;
    }

    protected void initializeConfiguration() throws ConfigurationProcessingException, ConfigurationResourceNotFoundException, PlexusConfigurationException, ContextException {
        PlexusXmlComponentDiscoverer discoverer;
        PlexusConfiguration plexusConfiguration;
        PlexusConfiguration bootstrapConfiguration;
        InputStream is = this.containerRealm.getResourceAsStream("org/codehaus/plexus/plexus-bootstrap.xml");
        if (is == null) {
            String realmStack = "";
            for (ClassRealm cr = this.containerRealm; cr != null; cr = cr.getParentRealm()) {
                realmStack = realmStack + "\n  " + cr.getId() + " parent=" + cr.getParent() + " (" + cr.getResource("org/codehaus/plexus/plexus-bootstrap.xml") + ")";
            }
            throw new IllegalStateException("The internal default plexus-bootstrap.xml is missing. This is highly irregular, your plexus JAR is most likely corrupt. Realms:" + realmStack);
        }
        this.configuration = bootstrapConfiguration = PlexusTools.buildConfiguration("org/codehaus/plexus/plexus-bootstrap.xml", new InputStreamReader(is));
        if (!(this.containerContext.contains("plexus.ignoreContainerConfiguration") && this.containerContext.get("plexus.ignoreContainerConfiguration") == Boolean.TRUE || (plexusConfiguration = (discoverer = new PlexusXmlComponentDiscoverer()).discoverConfiguration(this.getContext(), this.containerRealm)) == null)) {
            this.configuration = PlexusConfigurationMerger.merge(plexusConfiguration, this.configuration);
            this.processConfigurationsDirectory();
        }
        if (this.configurationReader != null) {
            PlexusConfiguration userConfiguration = PlexusTools.buildConfiguration("<User Specified Configuration Reader>", this.getInterpolationConfigurationReader(this.configurationReader));
            this.configuration = PlexusConfigurationMerger.merge(userConfiguration, this.configuration);
            this.processConfigurationsDirectory();
        }
        ConfigurationProcessor p = new ConfigurationProcessor();
        p.addConfigurationResourceHandler(new FileConfigurationResourceHandler());
        p.addConfigurationResourceHandler(new DirectoryConfigurationResourceHandler());
        this.configuration = p.process(this.configuration, Collections.EMPTY_MAP);
    }

    protected Reader getInterpolationConfigurationReader(Reader reader) {
        return new InterpolationFilterReader(reader, (Map)new ContextMapAdapter(this.containerContext));
    }

    private void processConfigurationsDirectory() throws PlexusConfigurationException {
        String s = this.configuration.getChild("configurations-directory").getValue(null);
        if (s != null) {
            PlexusConfiguration componentsConfiguration = this.configuration.getChild("components");
            File configurationsDirectory = new File(s);
            if (configurationsDirectory.exists() && configurationsDirectory.isDirectory()) {
                List componentConfigurationFiles;
                try {
                    componentConfigurationFiles = FileUtils.getFiles((File)configurationsDirectory, (String)"**/*.conf", (String)"**/*.xml");
                }
                catch (IOException e) {
                    throw new PlexusConfigurationException("Unable to locate configuration files", e);
                }
                Iterator i = componentConfigurationFiles.iterator();
                while (i.hasNext()) {
                    File componentConfigurationFile = (File)i.next();
                    FileReader reader = null;
                    try {
                        reader = new FileReader(componentConfigurationFile);
                        PlexusConfiguration componentConfiguration = PlexusTools.buildConfiguration(componentConfigurationFile.getAbsolutePath(), this.getInterpolationConfigurationReader(reader));
                        componentsConfiguration.addChild(componentConfiguration.getChild("components"));
                    }
                    catch (FileNotFoundException e) {
                        try {
                            throw new PlexusConfigurationException("File " + componentConfigurationFile + " disappeared before processing", e);
                        }
                        catch (Throwable throwable) {
                            IOUtil.close(reader);
                            throw throwable;
                        }
                    }
                    IOUtil.close((Reader)reader);
                }
            }
        }
    }

    public void addJarResource(File jar) throws PlexusContainerException {
        try {
            this.containerRealm.addURL(jar.toURI().toURL());
            if (this.initialized) {
                this.discoverComponents(this.containerRealm);
            }
        }
        catch (MalformedURLException e) {
            throw new PlexusContainerException("Cannot add jar resource: " + jar + " (bad URL)", e);
        }
        catch (PlexusConfigurationException e) {
            throw new PlexusContainerException("Cannot add jar resource: " + jar + " (error discovering new components)", e);
        }
        catch (ComponentRepositoryException e) {
            throw new PlexusContainerException("Cannot add jar resource: " + jar + " (error discovering new components)", e);
        }
    }

    public void addJarRepository(File repository) {
        if (repository.exists() && repository.isDirectory()) {
            File[] jars = repository.listFiles();
            for (int j = 0; j < jars.length; ++j) {
                if (!jars[j].getAbsolutePath().endsWith(".jar")) continue;
                try {
                    this.addJarResource(jars[j]);
                    continue;
                }
                catch (PlexusContainerException e) {
                    this.getLogger().warn("Unable to add JAR: " + jars[j], e);
                }
            }
        } else {
            String message = "The specified JAR repository doesn't exist or is not a directory: '" + repository.getAbsolutePath() + "'.";
            if (this.getLogger() != null) {
                this.getLogger().warn(message);
            } else {
                System.out.println(message);
            }
        }
    }

    public Logger getLogger() {
        return super.getLogger();
    }

    public void registerComponentDiscoveryListener(ComponentDiscoveryListener listener) {
        this.componentDiscovererManager.registerComponentDiscoveryListener(listener);
    }

    public void removeComponentDiscoveryListener(ComponentDiscoveryListener listener) {
        this.componentDiscovererManager.removeComponentDiscoveryListener(listener);
    }

    public Object autowire(Object component) throws CompositionException {
        SetterComponentComposer composer = new SetterComponentComposer();
        composer.assembleComponent(component, null, this);
        return component;
    }

    public Object createAndAutowire(String clazz) throws CompositionException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object component = this.containerRealm.loadClass(clazz).newInstance();
        SetterComponentComposer composer = new SetterComponentComposer();
        composer.assembleComponent(component, null, this);
        return component;
    }

    public void setReloadingEnabled(boolean reloadingEnabled) {
        this.reloadingEnabled = reloadingEnabled;
    }

    public boolean isReloadingEnabled() {
        return this.reloadingEnabled;
    }

    public ComponentRepository getComponentRepository() {
        return this.componentRepository;
    }

    public void setComponentRepository(ComponentRepository componentRepository) {
        this.componentRepository = componentRepository;
    }

    public ComponentManagerManager getComponentManagerManager() {
        return this.componentManagerManager;
    }

    public void setComponentManagerManager(ComponentManagerManager componentManagerManager) {
        this.componentManagerManager = componentManagerManager;
    }

    public LifecycleHandlerManager getLifecycleHandlerManager() {
        return this.lifecycleHandlerManager;
    }

    public void setLifecycleHandlerManager(LifecycleHandlerManager lifecycleHandlerManager) {
        this.lifecycleHandlerManager = lifecycleHandlerManager;
    }

    public ComponentDiscovererManager getComponentDiscovererManager() {
        return this.componentDiscovererManager;
    }

    public void setComponentDiscovererManager(ComponentDiscovererManager componentDiscovererManager) {
        this.componentDiscovererManager = componentDiscovererManager;
    }

    public ComponentFactoryManager getComponentFactoryManager() {
        return this.componentFactoryManager;
    }

    public void setComponentFactoryManager(ComponentFactoryManager componentFactoryManager) {
        this.componentFactoryManager = componentFactoryManager;
    }

    public ComponentLookupManager getComponentLookupManager() {
        return this.componentLookupManager;
    }

    public void setComponentLookupManager(ComponentLookupManager componentLookupManager) {
        this.componentLookupManager = componentLookupManager;
    }

    public ComponentComposerManager getComponentComposerManager() {
        return this.componentComposerManager;
    }

    public void setComponentComposerManager(ComponentComposerManager componentComposerManager) {
        this.componentComposerManager = componentComposerManager;
    }

    public LoggerManager getLoggerManager() {
        return this.loggerManager;
    }

    public void setLoggerManager(LoggerManager loggerManager) {
        this.loggerManager = loggerManager;
    }

    public PlexusConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(PlexusConfiguration configuration) {
        this.configuration = configuration;
    }

    public PlexusContainer getParentContainer() {
        return this.parentContainer;
    }

    public ClassRealm getComponentRealm(String realmId) {
        ClassRealm realm = null;
        try {
            realm = this.classWorld.getRealm(realmId);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            // empty catch block
        }
        if (realm == null) {
            realm = this.containerRealm;
        }
        return realm;
    }

    private static InputStream toStream(File file) throws PlexusContainerException {
        try {
            return file == null ? null : new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new PlexusContainerException("Could not read file: " + file.getAbsolutePath());
        }
    }

    private static InputStream toStream(URL url) throws PlexusContainerException {
        try {
            return url == null ? null : url.openStream();
        }
        catch (IOException e) {
            throw new PlexusContainerException("Could not read url: " + url);
        }
    }

    private static InputStream toStream(String resource) throws PlexusContainerException {
        if (resource == null) {
            return null;
        }
        InputStream in = DefaultPlexusContainer.class.getResourceAsStream(resource);
        if (in == null) {
            throw new PlexusContainerException("Could not load resource '" + resource + "'.");
        }
        return in;
    }

    public ClassRealm getLookupRealm(Object component) {
        if (component.getClass().getClassLoader() instanceof ClassRealm) {
            return (ClassRealm)component.getClass().getClassLoader();
        }
        return this.getLookupRealm();
    }
}

