/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.manager;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.factory.ComponentInstantiationException;
import org.codehaus.plexus.component.manager.AbstractComponentManager;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;

public class ClassicSingletonComponentManager
extends AbstractComponentManager {
    private Object lock;
    private Map singletonMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Object component) throws ComponentLifecycleException {
        Object object = this.lock;
        synchronized (object) {
            if (this.findSingleton(component) == component) {
                this.decrementConnectionCount();
                if (!this.connected()) {
                    this.dispose();
                }
            } else {
                this.getLogger().warn("Component returned which is not the same manager. Ignored. component=" + component, (Throwable)new Exception());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws ComponentLifecycleException {
        Object object = this.lock;
        synchronized (object) {
            Iterator i = this.singletonMap.values().iterator();
            while (i.hasNext()) {
                Object singleton = i.next();
                this.endComponentLifecycle(singleton);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getComponent(ClassRealm realm) throws ComponentInstantiationException, ComponentLifecycleException {
        Object object = this.lock;
        synchronized (object) {
            Object singleton = this.findSingleton(realm);
            if (singleton == null) {
                singleton = this.createComponentInstance(realm);
                if (this.getLogger() != null) {
                    this.getLogger().debug("Registering at " + this.componentDescriptor.getRealmId() + ": " + singleton.getClass().getName() + " (object realm: " + singleton.getClass().getClassLoader() + "), lookuprealm=" + realm.getId());
                }
                this.singletonMap.put(this.componentDescriptor.getRealmId(), singleton);
            }
            this.incrementConnectionCount();
            return singleton;
        }
    }

    protected Object findSingleton(ClassRealm realm) {
        while (realm != null) {
            Object o = this.singletonMap.get(realm.getId());
            if (o != null) {
                return o;
            }
            realm = realm.getParentRealm();
        }
        return null;
    }

    protected Object findSingleton(Object component) {
        ClassRealm classRealm = this.container.getLookupRealm(component);
        return this.findSingleton(classRealm == null ? this.container.getContainerRealm() : classRealm);
    }

    public void initialize() {
        this.singletonMap = new HashMap();
        this.lock = new Object();
    }
}

