/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters;

import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.configurator.AbstractComponentConfigurator;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractConfigurationConverter
implements ConfigurationConverter {
    protected MutablePlexusContainer container;
    private static final String IMPLEMENTATION = "implementation";
    static /* synthetic */ Class class$java$lang$String;

    protected AbstractConfigurationConverter() {
    }

    protected AbstractConfigurationConverter(MutablePlexusContainer conatiner) {
        this.container = conatiner;
    }

    protected Class getClassForImplementationHint(Class type, PlexusConfiguration configuration, ClassLoader classLoader) throws ComponentConfigurationException {
        return this.getClassForImplementationHint(type, configuration, AbstractComponentConfigurator.createClassRealm(this.container, classLoader));
    }

    protected Class getClassForImplementationHint(Class type, PlexusConfiguration configuration, ClassRealm classRealm) throws ComponentConfigurationException {
        Class retValue = type;
        String implementation = configuration.getAttribute(IMPLEMENTATION, null);
        if (implementation != null) {
            try {
                retValue = classRealm.loadClass(implementation);
            }
            catch (ClassNotFoundException e) {
                String msg = "Class name which was explicitly given in configuration using 'implementation' attribute: '" + implementation + "' cannot be loaded";
                throw new ComponentConfigurationException(msg, (Throwable)e);
            }
        }
        return retValue;
    }

    protected Class getImplementationClass(Class type, Class baseType, PlexusConfiguration configuration, ClassRealm classRealm) throws ComponentConfigurationException {
        Class childType = this.getClassForImplementationHint(null, configuration, classRealm);
        if (childType != null) {
            return childType;
        }
        String configEntry = configuration.getName();
        String name = this.fromXML(configEntry);
        if (name.indexOf(46) > 0) {
            try {
                return classRealm.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        String className = this.constructClassName(baseType, name);
        ClassNotFoundException lastException = null;
        try {
            return classRealm.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            lastException = e;
            if (type != null) {
                return type;
            }
            if (configuration.getChildCount() == 0) {
                return class$java$lang$String == null ? (class$java$lang$String = AbstractConfigurationConverter.class$("java.lang.String")) : class$java$lang$String;
            }
            throw new ComponentConfigurationException("Error loading class '" + className + "'", (Throwable)lastException);
        }
    }

    private String constructClassName(Class baseType, String name) {
        String className;
        String baseTypeName = baseType.getName();
        int lastDot = baseTypeName.lastIndexOf(46);
        if (lastDot == -1) {
            className = name;
        } else {
            String basePackage = baseTypeName.substring(0, lastDot);
            className = basePackage + "." + StringUtils.capitalizeFirstLetter((String)name);
        }
        return className;
    }

    protected Class loadClass(String classname, ClassLoader classLoader) throws ComponentConfigurationException {
        Class<?> retValue;
        try {
            retValue = classLoader.loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            throw new ComponentConfigurationException("Error loading class '" + classname + "'", (Throwable)e);
        }
        return retValue;
    }

    protected Object instantiateObject(String classname, ClassLoader classLoader) throws ComponentConfigurationException {
        Class clazz = this.loadClass(classname, classLoader);
        return this.instantiateObject(clazz);
    }

    protected Object instantiateObject(Class clazz) throws ComponentConfigurationException {
        try {
            Object retValue = clazz.newInstance();
            return retValue;
        }
        catch (IllegalAccessException e) {
            throw new ComponentConfigurationException("Class '" + clazz.getName() + "' cannot be instantiated", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ComponentConfigurationException("Class '" + clazz.getName() + "' cannot be instantiated", (Throwable)e);
        }
    }

    protected String fromXML(String elementName) {
        return StringUtils.lowercaseFirstLetter((String)StringUtils.removeAndHump((String)elementName, (String)"-"));
    }

    protected String toXML(String fieldName) {
        return StringUtils.addAndDeHump((String)fieldName);
    }

    protected Object fromExpression(PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator, Class type) throws ComponentConfigurationException {
        Object v = this.fromExpression(configuration, expressionEvaluator);
        if (v != null && !type.isAssignableFrom(v.getClass())) {
            String msg = "Cannot assign configuration entry '" + configuration.getName() + "' to '" + type + "' from '" + configuration.getValue(null) + "', which is of type " + v.getClass();
            throw new ComponentConfigurationException(configuration, msg);
        }
        return v;
    }

    protected Object fromExpression(PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator) throws ComponentConfigurationException {
        Object v = null;
        String value = configuration.getValue(null);
        if (value != null && value.length() > 0) {
            try {
                v = expressionEvaluator.evaluate(value);
            }
            catch (ExpressionEvaluationException e) {
                String msg = "Error evaluating the expression '" + value + "' for configuration value '" + configuration.getName() + "'";
                throw new ComponentConfigurationException(configuration, msg, e);
            }
        }
        if (v == null && (value = configuration.getAttribute("default-value", null)) != null && value.length() > 0) {
            try {
                v = expressionEvaluator.evaluate(value);
            }
            catch (ExpressionEvaluationException e) {
                String msg = "Error evaluating the expression '" + value + "' for configuration value '" + configuration.getName() + "'";
                throw new ComponentConfigurationException(configuration, msg, e);
            }
        }
        return v;
    }

    public Object fromConfiguration(ConverterLookup converterLookup, PlexusConfiguration configuration, Class type, Class baseType, ClassRealm classRealm, ExpressionEvaluator expressionEvaluator) throws ComponentConfigurationException {
        return this.fromConfiguration(converterLookup, configuration, type, baseType, classRealm, expressionEvaluator, null);
    }

    public Object fromConfiguration(ConverterLookup converterLookup, PlexusConfiguration configuration, Class type, Class baseType, ClassLoader classLoader, ExpressionEvaluator expressionEvaluator) throws ComponentConfigurationException {
        return this.fromConfiguration(converterLookup, configuration, type, baseType, AbstractComponentConfigurator.createClassRealm(this.container, classLoader), expressionEvaluator);
    }

    public Object fromConfiguration(ConverterLookup converterLookup, PlexusConfiguration configuration, Class type, Class baseType, ClassLoader classLoader, ExpressionEvaluator expressionEvaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        return this.fromConfiguration(converterLookup, configuration, type, baseType, AbstractComponentConfigurator.createClassRealm(this.container, classLoader), expressionEvaluator, listener);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ Object fromConfiguration(ConverterLookup var1, PlexusConfiguration var2, Class var3, Class var4, ClassRealm var5, ExpressionEvaluator var6, ConfigurationListener var7) throws ComponentConfigurationException;

    public abstract /* synthetic */ boolean canConvert(Class var1);
}

