/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.metadata;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.metadata.MetadataGenerationRequest;
import org.codehaus.plexus.metadata.MetadataGenerator;
import org.codehaus.plexus.tools.cli.AbstractCli;

public class PlexusMetadataGeneratorCli
extends AbstractCli {
    public static final char SOURCE_DIRECTORY = 's';
    public static final char SOURCE_ENCODING = 'e';
    public static final char CLASSES_DIRECTORY = 'c';
    public static final char OUTPUT_FILE = 'o';
    public static final char DESCRIPTORS_DIRECTORY = 'm';

    public static void main(String[] args) throws Exception {
        new PlexusMetadataGeneratorCli().execute(args);
    }

    public String getPomPropertiesPath() {
        return "META-INF/maven/org.codehaus.plexus/plexus-metadata-generator/pom.properties";
    }

    public Options buildCliOptions(Options options) {
        OptionBuilder.withLongOpt((String)"source");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Source directory.");
        options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"encoding");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Source file encoding.");
        options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.withLongOpt((String)"classes");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Classes directory.");
        options.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Output directory.");
        options.addOption(OptionBuilder.create((char)'o'));
        OptionBuilder.withLongOpt((String)"descriptors");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Descriptors directory.");
        options.addOption(OptionBuilder.create((char)'m'));
        return options;
    }

    public void invokePlexusComponent(CommandLine cli, PlexusContainer plexus) throws Exception {
        MetadataGenerator metadataGenerator = (MetadataGenerator)plexus.lookup(MetadataGenerator.class);
        MetadataGenerationRequest request = new MetadataGenerationRequest();
        request.classesDirectory = new File(cli.getOptionValue('c'));
        request.classpath = Collections.emptyList();
        request.sourceDirectories = Arrays.asList(new File(cli.getOptionValue('s')).getAbsolutePath());
        request.sourceEncoding = cli.getOptionValue('e');
        request.useContextClassLoader = true;
        request.outputFile = new File(cli.getOptionValue('o'));
        request.componentDescriptorDirectory = new File(cli.getOptionValue('m'));
        metadataGenerator.generateDescriptor(request);
    }
}

