/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.DirectoryScanner;

public abstract class AbstractArchiver
extends AbstractLogEnabled
implements Archiver {
    public static final int DEFAULT_DIR_MODE = 16877;
    public static final int DEFAULT_FILE_MODE = 33188;
    private Logger logger;
    private File destFile;
    private Map filesMap = new LinkedHashMap();
    private Map dirsMap = new LinkedHashMap();
    private int defaultFileMode = 33188;
    private boolean includeEmptyDirs = true;
    private int defaultDirectoryMode = 16877;

    public void setDefaultFileMode(int mode) {
        this.defaultFileMode = mode & 0xFFF | 0x8000;
    }

    public int getDefaultFileMode() {
        return this.defaultFileMode;
    }

    public void setDefaultDirectoryMode(int mode) {
        this.defaultDirectoryMode = mode & 0xFFF | 0x4000;
    }

    public int getDefaultDirectoryMode() {
        return this.defaultDirectoryMode;
    }

    public boolean getIncludeEmptyDirs() {
        return this.includeEmptyDirs;
    }

    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.includeEmptyDirs = includeEmptyDirs;
    }

    public void addDirectory(File directory) throws ArchiverException {
        this.addDirectory(directory, "");
    }

    public void addDirectory(File directory, String prefix) throws ArchiverException {
        this.addDirectory(directory, prefix, null, null);
    }

    public void addDirectory(File directory, String[] includes, String[] excludes) throws ArchiverException {
        this.addDirectory(directory, "", includes, excludes);
    }

    public void addDirectory(File directory, String prefix, String[] includes, String[] excludes) throws ArchiverException {
        int i;
        DirectoryScanner scanner = new DirectoryScanner();
        if (includes != null) {
            scanner.setIncludes(includes);
        }
        if (excludes != null) {
            scanner.setExcludes(excludes);
        }
        if (!directory.isDirectory()) {
            throw new ArchiverException(directory.getAbsolutePath() + " isn't a directory.");
        }
        String basedir = directory.getAbsolutePath();
        scanner.setBasedir(basedir);
        scanner.scan();
        if (this.includeEmptyDirs) {
            String[] dirs = scanner.getIncludedDirectories();
            for (i = 0; i < dirs.length; ++i) {
                String sourceDir = dirs[i].replace('\\', '/');
                String targetDir = (prefix == null ? "" : prefix) + sourceDir;
                this.getDirs().put(targetDir, ArchiveEntry.createEntry(targetDir, new File(basedir, sourceDir), this.getDefaultFileMode(), this.getDefaultDirectoryMode()));
            }
        }
        String[] files = scanner.getIncludedFiles();
        for (i = 0; i < files.length; ++i) {
            String sourceFile = files[i].replace('\\', '/');
            String targetFile = (prefix == null ? "" : prefix) + sourceFile;
            this.filesMap.put(targetFile, ArchiveEntry.createEntry(targetFile, new File(basedir, sourceFile), this.getDefaultFileMode(), this.getDefaultDirectoryMode()));
        }
    }

    public void addFile(File inputFile, String destFileName) throws ArchiverException {
        this.addFile(inputFile, destFileName, this.getDefaultFileMode());
    }

    public void addFile(File inputFile, String destFileName, int permissions) throws ArchiverException {
        if (!inputFile.isFile() || !inputFile.exists()) {
            throw new ArchiverException(inputFile.getAbsolutePath() + " isn't a file.");
        }
        destFileName = destFileName.replace('\\', '/');
        this.filesMap.put(destFileName, ArchiveEntry.createFileEntry(destFileName, inputFile, permissions));
    }

    public Map getFiles() {
        if (!this.includeEmptyDirs) {
            return this.filesMap;
        }
        LinkedHashMap resources = new LinkedHashMap();
        resources.putAll(this.getDirs());
        resources.putAll(this.filesMap);
        return resources;
    }

    public File getDestFile() {
        return this.destFile;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
        if (destFile != null) {
            destFile.getParentFile().mkdirs();
        }
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = super.getLogger() != null ? super.getLogger() : new ConsoleLogger(1, "console");
        }
        return this.logger;
    }

    public Map getDirs() {
        return this.dirsMap;
    }

    public abstract /* synthetic */ void createArchive() throws ArchiverException, IOException;
}

