/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.appserver.service.deploy.lifecycle.phase;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.appserver.service.deploy.lifecycle.ServiceDeploymentContext;
import org.codehaus.plexus.appserver.service.deploy.lifecycle.ServiceDeploymentException;
import org.codehaus.plexus.appserver.service.deploy.lifecycle.phase.AbstractServiceDeploymentPhase;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.component.repository.io.PlexusTools;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;

public class ProcessServiceConfigurationPhase
extends AbstractServiceDeploymentPhase {
    public void execute(ServiceDeploymentContext context) throws ServiceDeploymentException {
        File config = new File(new File(context.getServiceDirectory(), "conf"), "service.xml");
        try {
            FileReader reader = new FileReader(config);
            PlexusConfiguration serviceConfig = PlexusTools.buildConfiguration((String)config.getPath(), (Reader)reader);
            this.startComponents(serviceConfig, context.getContainer());
        }
        catch (FileNotFoundException e) {
            throw new ServiceDeploymentException("Cannot find configuration file.", e);
        }
        catch (PlexusConfigurationException e) {
            throw new ServiceDeploymentException("Error reading service configuration.", e);
        }
        catch (ComponentLookupException e) {
            throw new ServiceDeploymentException("Error starting service.", e);
        }
    }

    private void startComponents(PlexusConfiguration serviceConfig, DefaultPlexusContainer container) throws PlexusConfigurationException, ComponentLookupException {
        PlexusConfiguration[] loadOnStartComponents = serviceConfig.getChild("load-on-start").getChildren("component");
        this.getLogger().debug("Found " + loadOnStartComponents.length + " components to load on start");
        for (int i = 0; i < loadOnStartComponents.length; ++i) {
            String role = loadOnStartComponents[i].getChild("role").getValue(null);
            String roleHint = loadOnStartComponents[i].getChild("role-hint").getValue();
            if (role == null) {
                throw new PlexusConfigurationException("Missing 'role' element from load-on-start.");
            }
            if (roleHint == null) {
                this.getLogger().info("Loading on start [role]: [" + role + "]");
            } else {
                this.getLogger().info("Loading on start [role,roleHint]: [" + role + "," + roleHint + "]");
            }
            if (roleHint == null) {
                container.lookup(role);
                continue;
            }
            container.lookup(role, roleHint);
        }
    }
}

