/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.appserver.application.deploy.lifecycle.phase;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.classworlds.DuplicateRealmException;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.appserver.application.deploy.lifecycle.AppDeploymentContext;
import org.codehaus.plexus.appserver.application.deploy.lifecycle.AppDeploymentException;
import org.codehaus.plexus.appserver.application.deploy.lifecycle.phase.AbstractAppDeploymentPhase;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.context.ContextMapAdapter;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;

public class CreateAppContainerPhase
extends AbstractAppDeploymentPhase {
    public void execute(AppDeploymentContext context) throws AppDeploymentException {
        Xpp3Dom dom;
        DefaultPlexusContainer applicationContainer = new DefaultPlexusContainer();
        try {
            FileInputStream stream = new FileInputStream(context.getAppConfigurationFile());
            InputStreamReader r = new InputStreamReader(stream);
            applicationContainer.setConfigurationResource((Reader)r);
        }
        catch (Exception e) {
            throw new AppDeploymentException("Error processing application configurator.", e);
        }
        Properties contextValues = context.getContext();
        if (contextValues != null) {
            Iterator i = ((Hashtable)contextValues).keySet().iterator();
            while (i.hasNext()) {
                String contextName = (String)i.next();
                applicationContainer.addContextValue((Object)contextName, (Object)contextValues.getProperty(contextName));
            }
        }
        DefaultPlexusContainer appServerContainer = context.getAppServerContainer();
        this.getLogger().info("Using appDir = " + context.getAppDir());
        try {
            String plexusHome = (String)context.getAppServerContainer().getContext().get((Object)"plexus.home");
            applicationContainer.addContextValue((Object)"appserver.home", (Object)new File(plexusHome).getCanonicalPath());
        }
        catch (Exception e) {
            // empty catch block
        }
        applicationContainer.addContextValue((Object)"plexus.home", (Object)context.getAppDir().getAbsolutePath());
        applicationContainer.addContextValue((Object)"app.home", (Object)context.getAppDir().getAbsolutePath());
        applicationContainer.addContextValue((Object)"user.home", (Object)System.getProperty("user.home"));
        Object appserver = null;
        try {
            appserver = appServerContainer.getContext().get((Object)"plexus.appserver");
        }
        catch (ContextException e) {
            // empty catch block
        }
        applicationContainer.addContextValue((Object)"plexus.appserver", appserver);
        applicationContainer.setParentPlexusContainer((PlexusContainer)appServerContainer);
        applicationContainer.setClassWorld(appServerContainer.getClassWorld());
        SimpleClassRealm realm = new SimpleClassRealm("plexus.application." + context.getApplicationId(), new SimpleClassLoader(appServerContainer.getContainerRealm().getClassLoader()), appServerContainer.getClassWorld());
        applicationContainer.setCoreRealm((ClassRealm)realm);
        ContextMapAdapter ctx = new ContextMapAdapter(applicationContainer.getContext());
        try {
            InterpolationFilterReader configurationReader = new InterpolationFilterReader((Reader)new FileReader(context.getAppConfigurationFile()), (Map)ctx);
            dom = Xpp3DomBuilder.build((Reader)configurationReader);
        }
        catch (Exception e) {
            throw new AppDeploymentException("Error processing application configurator.", e);
        }
        XmlPlexusConfiguration applicationConfiguration = new XmlPlexusConfiguration(dom);
        context.setAppConfiguration((PlexusConfiguration)applicationConfiguration);
        context.setApplicationContainer(applicationContainer);
    }

    class SimpleClassRealm
    implements ClassRealm {
        private String id;
        private ClassWorld world;
        SimpleClassLoader classLoader;

        public SimpleClassRealm(String id, SimpleClassLoader classLoader, ClassWorld world) {
            this.id = id;
            this.classLoader = classLoader;
            this.world = world;
        }

        public String getId() {
            return this.id;
        }

        public void addConstituent(URL url) {
            this.classLoader.addURL(url);
        }

        public ClassRealm locateSourceRealm(String a) {
            throw new UnsupportedOperationException();
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public URL[] getConstituents() {
            return this.classLoader.getURLs();
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            return this.classLoader.loadClass(name);
        }

        public URL getResource(String name) {
            return this.classLoader.getResource(name);
        }

        public Enumeration findResources(String name) throws IOException {
            return this.classLoader.findResources(name);
        }

        public ClassWorld getWorld() {
            return this.world;
        }

        public void importFrom(String a, String b) {
            throw new UnsupportedOperationException();
        }

        public void setParent(ClassRealm c) {
        }

        public InputStream getResourceAsStream(String name) {
            return ((ClassLoader)this.classLoader).getResourceAsStream(name);
        }

        public ClassRealm getParent() {
            throw new UnsupportedOperationException();
        }

        public ClassRealm createChildRealm(String id) throws DuplicateRealmException {
            throw new UnsupportedOperationException();
        }

        public void display() {
            URL[] urls = this.classLoader.getURLs();
            for (int i = 0; i < urls.length; ++i) {
                System.out.println("url = " + urls[i]);
            }
        }
    }

    class SimpleClassLoader
    extends URLClassLoader {
        public SimpleClassLoader(ClassLoader classLoader) {
            super(new URL[0], classLoader);
        }

        public void addURL(URL url) {
            super.addURL(url);
        }
    }
}

