/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.appserver.application.deploy.lifecycle.phase;

import org.codehaus.plexus.appserver.application.deploy.lifecycle.AppDeploymentContext;
import org.codehaus.plexus.appserver.application.deploy.lifecycle.AppDeploymentException;
import org.codehaus.plexus.appserver.application.deploy.lifecycle.phase.AbstractAppDeploymentPhase;
import org.codehaus.plexus.appserver.service.PlexusService;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.StringUtils;

public class BeforeAppStartServiceSetupPhase
extends AbstractAppDeploymentPhase {
    public void execute(AppDeploymentContext context) throws AppDeploymentException {
        PlexusConfiguration[] services = context.getAppConfiguration().getChild("services").getChildren("service");
        for (int i = 0; i < services.length; ++i) {
            PlexusService service;
            PlexusConfiguration serviceConfiguration = services[i];
            String id = serviceConfiguration.getChild("id").getValue("");
            if (StringUtils.isEmpty((String)id)) {
                throw new AppDeploymentException("Missing child element 'id' in 'service'.");
            }
            try {
                service = (PlexusService)context.getAppServerContainer().lookup(PlexusService.ROLE, id);
            }
            catch (ComponentLookupException e) {
                throw new AppDeploymentException("Error looking up service for pre app init call.", e);
            }
            context.getAppRuntimeProfile().getServices().add(service);
            PlexusConfiguration conf = serviceConfiguration.getChild("configuration");
            context.getAppRuntimeProfile().getServiceConfigurations().add(conf);
            try {
                service.beforeApplicationStart(context.getAppRuntimeProfile(), conf);
                continue;
            }
            catch (Exception e) {
                throw new AppDeploymentException("Error executing service.", e);
            }
        }
        context.getDeployments().put(context.getApplicationId(), context.getAppRuntimeProfile());
    }
}

