/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.appserver;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.appserver.AppDescriptor;
import org.codehaus.plexus.appserver.ApplicationServer;
import org.codehaus.plexus.appserver.ApplicationServerException;
import org.codehaus.plexus.appserver.application.deploy.ApplicationDeployer;
import org.codehaus.plexus.appserver.application.profile.AppRuntimeProfile;
import org.codehaus.plexus.appserver.lifecycle.AppServerContext;
import org.codehaus.plexus.appserver.lifecycle.AppServerLifecycleException;
import org.codehaus.plexus.appserver.lifecycle.phase.AppServerPhase;
import org.codehaus.plexus.appserver.service.deploy.ServiceDeployer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Startable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.StartingException;

public class DefaultApplicationServer
extends AbstractLogEnabled
implements ApplicationServer,
Initializable,
Contextualizable,
Startable {
    private PlexusContainer container;
    private ApplicationDeployer applicationDeployer;
    private ServiceDeployer serviceDeployer;
    private List phases;
    private Map appDescriptors;

    public AppRuntimeProfile getApplicationRuntimeProfile(String applicationId) throws ApplicationServerException {
        return this.applicationDeployer.getApplicationRuntimeProfile(applicationId);
    }

    public void deploy(String id, File location) throws ApplicationServerException {
        this.applicationDeployer.deploy(id, location);
    }

    public void redeploy(String id) throws ApplicationServerException {
        this.applicationDeployer.redeploy(id);
    }

    public void undeploy(String id) throws ApplicationServerException {
        this.applicationDeployer.undeploy(id);
    }

    public void addAppDescriptor(AppDescriptor appDescriptor) {
        this.appDescriptors.put(appDescriptor.getId(), appDescriptor);
    }

    public AppDescriptor getAppDescriptor(String appId) {
        return (AppDescriptor)this.appDescriptors.get(appId);
    }

    public Collection getAppDescriptors() {
        return this.appDescriptors.values();
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
        this.container.addContextValue((Object)"plexus.appserver", (Object)this);
    }

    public void initialize() throws InitializationException {
        this.appDescriptors = new LinkedHashMap();
    }

    public void start() throws StartingException {
        File appServerHome = new File(System.getProperty("plexus.home"));
        AppServerContext appServerContext = new AppServerContext(this, appServerHome);
        Iterator i = this.phases.iterator();
        while (i.hasNext()) {
            String appServerPhaseId = (String)i.next();
            try {
                AppServerPhase appServerPhase = (AppServerPhase)this.container.lookup(AppServerPhase.ROLE, appServerPhaseId);
                appServerPhase.execute(appServerContext);
            }
            catch (ComponentLookupException e) {
                throw new StartingException("The requested app server lifecycle phase cannot be found: " + appServerPhaseId, (Throwable)e);
            }
            catch (AppServerLifecycleException e) {
                throw new StartingException("Error in the app server lifecycle " + appServerPhaseId + " phase.", (Throwable)e);
            }
        }
        this.getLogger().info("The appserver server has been initialized.");
    }

    public void stop() {
    }
}

