/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.factory.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.DemuxInputStream;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.helper.ProjectHelper2;
import org.codehaus.plexus.component.MapOrientedComponent;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.factory.ant.AntComponentExecutionException;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.IOUtil;

public class AntScriptInvoker
extends AbstractLogEnabled
implements MapOrientedComponent {
    public static final String BASEDIR_PARAMETER = "basedir";
    public static final String MESSAGE_LEVEL_PARAMETER = "messageLevel";
    private final ComponentDescriptor descriptor;
    private final File script;
    private final String scriptResource;
    private String target;
    private Map references = new HashMap();
    private Properties properties = new Properties();
    private Project project;
    private File basedir;
    private String messageLevel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AntScriptInvoker(ComponentDescriptor descriptor, ClassLoader loader) throws IOException {
        String resourceName;
        this.descriptor = descriptor;
        String impl = descriptor.getImplementation();
        int colon = impl.indexOf(":");
        if (colon > -1) {
            resourceName = impl.substring(0, colon);
            this.target = impl.substring(colon + 1);
        } else {
            resourceName = impl;
        }
        this.scriptResource = resourceName;
        InputStream input = null;
        FileOutputStream output = null;
        try {
            input = loader.getResourceAsStream(resourceName);
            this.script = File.createTempFile("plexus-ant-component", ".build.xml");
            this.script.deleteOnExit();
            output = new FileOutputStream(this.script);
            IOUtil.copy((InputStream)input, (OutputStream)output);
        }
        catch (Throwable throwable) {
            IOUtil.close((InputStream)input);
            IOUtil.close(output);
            throw throwable;
        }
        IOUtil.close((InputStream)input);
        IOUtil.close((OutputStream)output);
    }

    public static String[] getImplicitRequiredParameters() {
        return new String[]{BASEDIR_PARAMETER};
    }

    public static String[] getImplicitOptionalParameters() {
        return new String[]{MESSAGE_LEVEL_PARAMETER};
    }

    public void addComponentRequirement(ComponentRequirement rd, Object rv) throws ComponentConfigurationException {
        if (!this.descriptor.getRequirements().contains(rd)) {
            throw new ComponentConfigurationException("Requirement: " + rd.getHumanReadableKey() + " is not listed in this component's descriptor.");
        }
        this.references.put(rd.getRole() + "_" + rd.getRoleHint(), rv);
    }

    public void setComponentConfiguration(Map componentConfiguration) throws ComponentConfigurationException {
        Iterator it = componentConfiguration.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            Object val = entry.getValue();
            if (key instanceof String && val instanceof String) {
                this.properties.setProperty((String)key, (String)val);
                continue;
            }
            this.references.put(key, val);
        }
        Object basedirInput = componentConfiguration.get(BASEDIR_PARAMETER);
        if (basedirInput instanceof File) {
            this.basedir = (File)basedirInput;
        } else if (basedirInput != null) {
            this.basedir = new File(String.valueOf(basedirInput));
        } else {
            throw new ComponentConfigurationException("'basedir' parameter is missing.");
        }
        Object messageLevelInput = componentConfiguration.get(MESSAGE_LEVEL_PARAMETER);
        if (messageLevelInput != null) {
            this.messageLevel = String.valueOf(messageLevelInput);
        }
        this.initializeProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() throws AntComponentExecutionException {
        InputStream oldSysIn = System.in;
        PrintStream oldSysOut = System.out;
        PrintStream oldSysErr = System.err;
        try {
            this.project.setDefaultInputStream(System.in);
            System.setIn((InputStream)new DemuxInputStream(this.project));
            System.setOut(new PrintStream((OutputStream)new DemuxOutputStream(this.project, false)));
            System.setErr(new PrintStream((OutputStream)new DemuxOutputStream(this.project, true)));
            this.project.fireBuildStarted();
            BuildException error = null;
            try {
                String key;
                Map.Entry<Object, Object> entry;
                try {
                    ProjectHelper2 helper = new ProjectHelper2();
                    this.project.addReference("ant.projectHelper", (Object)helper);
                    helper.parse(this.project, (Object)this.script);
                }
                catch (BuildException ex) {
                    error = ex;
                    throw new AntComponentExecutionException(this.scriptResource, this.target, "Failed to parse.", ex);
                }
                Iterator<Map.Entry<Object, Object>> it = this.references.entrySet().iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    key = (String)entry.getKey();
                    this.project.addReference(key, entry.getValue());
                }
                it = this.properties.entrySet().iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    key = (String)entry.getKey();
                    this.project.setUserProperty(key, this.properties.getProperty(key));
                }
                try {
                    this.project.executeTarget(this.target);
                }
                catch (BuildException e) {
                    error = e;
                    throw new AntComponentExecutionException(this.scriptResource, this.target, "Failed to execute.", e);
                }
            }
            finally {
                this.project.fireSubBuildFinished((Throwable)error);
            }
        }
        finally {
            this.project = null;
            System.setIn(oldSysIn);
            System.setOut(oldSysOut);
            System.setErr(oldSysErr);
        }
    }

    private void initializeProject() {
        this.project = new Project();
        this.project.init();
        this.project.setUserProperty("ant.version", Main.getAntVersion());
        this.project.setProperty("ant.file", this.script.toString());
        DefaultLogger antLogger = new DefaultLogger();
        antLogger.setOutputPrintStream(System.out);
        antLogger.setErrorPrintStream(System.err);
        int level = this.convertMsgLevel(this.messageLevel);
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.debug("Ant message level is set to: " + this.messageLevel + "(" + level + ")");
        }
        antLogger.setMessageOutputLevel(level);
        this.project.addBuildListener((BuildListener)antLogger);
        this.project.setBaseDir(this.basedir);
    }

    protected int convertMsgLevel(String msgLevel) {
        int level;
        if (msgLevel == null) {
            return 0;
        }
        if ((msgLevel = msgLevel.toLowerCase()).equals("error")) {
            level = 0;
        } else if (msgLevel.equals("warning") || msgLevel.equals("warn")) {
            level = 1;
        } else if (msgLevel.equals("information") || msgLevel.equals("info")) {
            level = 2;
        } else if (msgLevel.equals("debug")) {
            level = 4;
        } else if (msgLevel.equals("verbose")) {
            level = 3;
        } else {
            Logger logger = this.getLogger();
            if (logger != null) {
                logger.info("Unknown Ant Message Level (" + msgLevel + ") -- using \"error\" instead");
            }
            level = 0;
        }
        return level;
    }

    public Project getProject() {
        return this.project;
    }
}

