/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.dom.scoping;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.openxma.dsl.core.scoping.CoreDslScopeProvider;
import org.openxma.dsl.dom.model.Attribute;
import org.openxma.dsl.dom.model.AttributeGroup;
import org.openxma.dsl.dom.model.CallInputParameter;
import org.openxma.dsl.dom.model.CallOutputParameter;
import org.openxma.dsl.dom.model.CallableStatement;
import org.openxma.dsl.dom.model.Column;
import org.openxma.dsl.dom.model.ComplexType;
import org.openxma.dsl.dom.model.Dao;
import org.openxma.dsl.dom.model.DaoFeature;
import org.openxma.dsl.dom.model.DataBaseConstraint;
import org.openxma.dsl.dom.model.DataView;
import org.openxma.dsl.dom.model.DelegateOperation;
import org.openxma.dsl.dom.model.Entity;
import org.openxma.dsl.dom.model.FeatureReference;
import org.openxma.dsl.dom.model.FromClass;
import org.openxma.dsl.dom.model.Join;
import org.openxma.dsl.dom.model.ManyToOne;
import org.openxma.dsl.dom.model.Mapper;
import org.openxma.dsl.dom.model.OneToMany;
import org.openxma.dsl.dom.model.Parameter;
import org.openxma.dsl.dom.model.PropertyMapping;
import org.openxma.dsl.dom.model.QueryOperation;
import org.openxma.dsl.dom.model.QueryParameter;
import org.openxma.dsl.dom.model.QueryParameterValue;
import org.openxma.dsl.dom.model.ValueObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomDslScopeProvider
extends CoreDslScopeProvider {
    public final IScope scope_CallInputParameter_reference(CallableStatement callableStatement, EReference reference) {
        QueryOperation queryOperation = (QueryOperation)EcoreUtil2.getContainerOfType((EObject)callableStatement, QueryOperation.class);
        return new SimpleScope(Scopes.scopedElementsFor(queryOperation.getQueryParameters()));
    }

    public final IScope scope_CallInputParameter_attribute(CallInputParameter inputParameter, EReference reference) {
        Parameter parameter;
        QueryParameter queryParameter = inputParameter.getParameter();
        if (queryParameter instanceof Parameter && (parameter = (Parameter)queryParameter).getType() instanceof ComplexType) {
            ComplexType complexType = (ComplexType)parameter.getType();
            return new SimpleScope(Scopes.scopedElementsFor(complexType.getAllAttributes()));
        }
        return IScope.NULLSCOPE;
    }

    public final IScope scope_CallOutputParameter_attribute(CallableStatement callableStatement, EReference reference) {
        QueryOperation queryOperation = (QueryOperation)EcoreUtil2.getContainerOfType((EObject)callableStatement, QueryOperation.class);
        ArrayList outParametersScope = Lists.newArrayList();
        if (queryOperation.getType() instanceof ComplexType) {
            ComplexType complexType = (ComplexType)queryOperation.getType();
            outParametersScope.addAll(complexType.getAllAttributes());
        }
        return new SimpleScope(Scopes.scopedElementsFor((Iterable)Iterables.concat((Iterable)outParametersScope, this.getInputParameters(callableStatement))));
    }

    public final IScope scope_CallOutputParameter_nestedAttribute(CallOutputParameter callOutputParameter, EReference reference) {
        Attribute attribute = callOutputParameter.getAttribute();
        if (attribute.getDataType() instanceof ComplexType) {
            ComplexType complexType = (ComplexType)attribute.getDataType();
            return new SimpleScope(Scopes.scopedElementsFor(complexType.getAllAttributes()));
        }
        return IScope.NULLSCOPE;
    }

    private List<EObject> getInputParameters(CallableStatement callableStatement) {
        QueryOperation queryOperation = (QueryOperation)EcoreUtil2.getContainerOfType((EObject)callableStatement, QueryOperation.class);
        ArrayList inParametersScope = Lists.newArrayList();
        EList<QueryParameter> queryParameters = queryOperation.getQueryParameters();
        for (QueryParameter queryParameter : queryParameters) {
            if (queryParameter.getAttribute() != null) {
                inParametersScope.add(queryParameter.getAttribute());
                continue;
            }
            if (!(queryParameter instanceof Parameter)) continue;
            Parameter parameter = (Parameter)queryParameter;
            inParametersScope.add(queryParameter);
            if (!(parameter.getType() instanceof ComplexType)) continue;
            ComplexType complexType = (ComplexType)parameter.getType();
            inParametersScope.addAll(complexType.getAllAttributes());
        }
        return inParametersScope;
    }

    public final IScope scope_QueryParameter_attribute(QueryParameter queryParameter, EReference reference) {
        Dao dao = (Dao)EcoreUtil2.getContainerOfType((EObject)queryParameter, Dao.class);
        return new SimpleScope(Scopes.scopedElementsFor(dao.getEntity().getAllAttributes()));
    }

    public final IScope scope_QueryParameter_attribute(QueryOperation queryOperation, EReference reference) {
        Dao dao = (Dao)EcoreUtil2.getContainerOfType((EObject)queryOperation, Dao.class);
        return new SimpleScope(Scopes.scopedElementsFor(dao.getEntity().getAllAttributes()));
    }

    public final IScope scope_Join_reference(Join join, EReference reference) {
        if (join.getEntity() instanceof FromClass) {
            FromClass fromClass = (FromClass)join.getEntity();
            return this.getScopeForReferences(fromClass.getEntity());
        }
        Join referenceJoin = (Join)join.getEntity();
        Attribute joinReference = referenceJoin.getReference();
        Entity joinEntity = (Entity)joinReference.getDataType();
        return this.getScopeForReferences(joinEntity);
    }

    private IScope getScopeForReferences(Entity entity) {
        EList<Attribute> attributes = entity.getAllAttributes();
        Iterable references = Scopes.scopedElementsFor((Iterable)Collections2.filter(attributes, (Predicate)new Predicate<Attribute>(){

            public boolean apply(Attribute input) {
                return input.isReference();
            }
        }));
        return new SimpleScope(references);
    }

    public final IScope scope_QueryParameterValue_parameter(QueryParameterValue queryParameterValue, EReference reference) {
        QueryOperation queryOperation = (QueryOperation)EcoreUtil2.getContainerOfType((EObject)queryParameterValue, QueryOperation.class);
        ArrayList attributes = Lists.newArrayList();
        EList<QueryParameter> queryParameters = queryOperation.getQueryParameters();
        for (QueryParameter queryParameter : queryParameters) {
            if (queryParameter.getAttribute() != null) {
                attributes.add(queryParameter.getAttribute());
                continue;
            }
            attributes.add(queryParameter);
        }
        return new SimpleScope(Scopes.scopedElementsFor((Iterable)attributes));
    }

    public final IScope scope_QueryParameterValue_attribute(QueryParameterValue queryParameterValue, EReference reference) {
        QueryOperation queryOperation = (QueryOperation)EcoreUtil2.getContainerOfType((EObject)queryParameterValue, QueryOperation.class);
        ArrayList attributes = Lists.newArrayList();
        for (Parameter queryParameter : Iterables.filter(queryOperation.getQueryParameters(), Parameter.class)) {
            if (queryParameter.getType() instanceof DataView) {
                DataView dataView = (DataView)queryParameter.getType();
                attributes.addAll(dataView.getAllAttributes());
                continue;
            }
            if (!(queryParameter.getType() instanceof ComplexType)) continue;
            ComplexType type = (ComplexType)queryParameter.getType();
            attributes.addAll(type.getAllAttributes());
        }
        return new SimpleScope(Scopes.scopedElementsFor((Iterable)attributes));
    }

    public final IScope scope_DaoFeature_attribute(DaoFeature daoFeature, EReference eReference) {
        if (daoFeature.eContainer() instanceof ManyToOne) {
            ManyToOne manyToOne = (ManyToOne)daoFeature.eContainer();
            Entity referencedEntity = (Entity)manyToOne.getAttribute().getDataType();
            return new SimpleScope(Scopes.scopedElementsFor(referencedEntity.getAllAttributes()));
        }
        if (daoFeature.eContainer() instanceof OneToMany) {
            OneToMany oneToMany = (OneToMany)daoFeature.eContainer();
            Entity entity = (Entity)oneToMany.getAttribute().eContainer();
            return new SimpleScope(Scopes.scopedElementsFor(entity.getAllAttributes()));
        }
        if (daoFeature.eContainer() instanceof Column) {
            Column nestedColumn = (Column)daoFeature.eContainer();
            ValueObject valueObject = (ValueObject)nestedColumn.getAttribute().getDataType();
            return Scopes.scopeFor(valueObject.getAttributes());
        }
        Dao dao = (Dao)daoFeature.eContainer();
        return new SimpleScope(Scopes.scopedElementsFor(dao.getEntity().getAllAttributes()));
    }

    public final IScope scope_AttributeSortOrder_attribute(AttributeGroup attributeGroup, EReference eReference) {
        Entity entity = (Entity)attributeGroup.eContainer();
        return new SimpleScope(Scopes.scopedElementsFor(entity.getAllAttributes()));
    }

    public final IScope scope_Attribute_sortOrder(Attribute feature, EReference eReference) {
        return new SimpleScope(Scopes.scopedElementsFor(((Entity)feature.getDataType()).getSortOrders()));
    }

    public final IScope scope_OneToMany_sortOrder(OneToMany oneToMany, EReference eReference) {
        return new SimpleScope(Scopes.scopedElementsFor(((Entity)oneToMany.getAttribute().getDataType()).getSortOrders()));
    }

    public final IScope scope_FeatureReference_attribute(FeatureReference featureReference, EReference eReference) {
        return new SimpleScope(Scopes.scopedElementsFor(featureReference.getSource().getAllAttributes()));
    }

    public final IScope scope_DataBaseConstraint_attributes(DataBaseConstraint dataBaseConstraint, EReference eReference) {
        Dao dao = (Dao)EcoreUtil2.getContainerOfType((EObject)dataBaseConstraint, Dao.class);
        return new SimpleScope(Scopes.scopedElementsFor(dao.getEntity().getAllAttributes()));
    }

    public final IScope scope_Attribute_opposite(Attribute attribute, EReference eReference) {
        if (attribute.isReference()) {
            Entity opposite = (Entity)attribute.getDataType();
            return new SimpleScope(Scopes.scopedElementsFor((Iterable)Iterables.filter(opposite.getAllAttributes(), (Predicate)new Predicate<Attribute>(){

                public boolean apply(Attribute input) {
                    return input.isReference();
                }
            })));
        }
        return IScope.NULLSCOPE;
    }

    public IScope scope_Reference_type(Attribute attribute, EReference eReference) {
        return super.getScope(attribute.eContainer(), eReference);
    }

    public final IScope scope_DelegateOperation_operation(DelegateOperation delegateOperation, EReference eReference) {
        return new SimpleScope(Scopes.scopedElementsFor((Iterable)Iterables.concat(delegateOperation.getRepository().getOperations(), delegateOperation.getRepository().getQueryOperation())));
    }

    public final IScope scope_PropertyMapping_left(Mapper mapping, EReference eReference) {
        return new SimpleScope(Scopes.scopedElementsFor(mapping.getLeft().getAllAttributes()));
    }

    public final IScope scope_PropertyMapping_left(PropertyMapping mapping, EReference eReference) {
        return new SimpleScope(Scopes.scopedElementsFor(((Mapper)mapping.eContainer()).getLeft().getAllAttributes()));
    }

    public final IScope scope_PropertyMapping_right(PropertyMapping mapping, EReference eReference) {
        return new SimpleScope(Scopes.scopedElementsFor(((Mapper)mapping.eContainer()).getRight().getAllAttributes()));
    }
}

