/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.dom.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DataBaseDialect implements Enumerator
{
    ORACLE(0, "ORACLE", "Oracle"),
    HSQLDB(1, "HSQLDB", "HsqlDb"),
    MYSQL(2, "MYSQL", "MySql");

    public static final int ORACLE_VALUE = 0;
    public static final int HSQLDB_VALUE = 1;
    public static final int MYSQL_VALUE = 2;
    private static final DataBaseDialect[] VALUES_ARRAY;
    public static final List<DataBaseDialect> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static DataBaseDialect get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            DataBaseDialect result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static DataBaseDialect getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            DataBaseDialect result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static DataBaseDialect get(int value) {
        switch (value) {
            case 0: {
                return ORACLE;
            }
            case 1: {
                return HSQLDB;
            }
            case 2: {
                return MYSQL;
            }
        }
        return null;
    }

    private DataBaseDialect(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new DataBaseDialect[]{ORACLE, HSQLDB, MYSQL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

