/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.dom.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DataBaseConstraintType implements Enumerator
{
    NULL(0, "NULL", "NULL"),
    INDEX(1, "INDEX", "index"),
    UNIQUE(2, "UNIQUE", "unique"),
    NATURAL(3, "NATURAL", "natural"),
    PRIMARY(4, "PRIMARY", "primary");

    public static final int NULL_VALUE = 0;
    public static final int INDEX_VALUE = 1;
    public static final int UNIQUE_VALUE = 2;
    public static final int NATURAL_VALUE = 3;
    public static final int PRIMARY_VALUE = 4;
    private static final DataBaseConstraintType[] VALUES_ARRAY;
    public static final List<DataBaseConstraintType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static DataBaseConstraintType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            DataBaseConstraintType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static DataBaseConstraintType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            DataBaseConstraintType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static DataBaseConstraintType get(int value) {
        switch (value) {
            case 0: {
                return NULL;
            }
            case 1: {
                return INDEX;
            }
            case 2: {
                return UNIQUE;
            }
            case 3: {
                return NATURAL;
            }
            case 4: {
                return PRIMARY;
            }
        }
        return null;
    }

    private DataBaseConstraintType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new DataBaseConstraintType[]{NULL, INDEX, UNIQUE, NATURAL, PRIMARY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

