/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.xmlbeans;

import java.io.IOException;
import java.net.URI;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.apache.xmlbeans.impl.tool.SchemaCompiler;
import org.codehaus.mojo.xmlbeans.PluginProperties;
import org.codehaus.mojo.xmlbeans.XmlBeansException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ParameterAdapter {
    private ParameterAdapter() {
    }

    static SchemaCompiler.Parameters getCompilerParameters(PluginProperties properties) throws DependencyResolutionRequiredException, XmlBeansException {
        SchemaCompiler.Parameters params = new SchemaCompiler.Parameters();
        params.setBaseDir(properties.getBaseDir());
        params.setXsdFiles(properties.getXsdFiles());
        params.setWsdlFiles(properties.getWsdlFiles());
        params.setJavaFiles(properties.getJavaFiles());
        params.setConfigFiles(properties.getConfigFiles());
        params.setClasspath(properties.getClasspath());
        params.setOutputJar(properties.getOutputJar());
        params.setName(properties.getName());
        params.setSrcDir(properties.getGeneratedSourceDirectory());
        params.setClassesDir(properties.getGeneratedClassesDirectory());
        params.setCompiler(properties.getCompiler());
        params.setMemoryInitialSize(properties.getMemoryInitialSize());
        params.setMemoryMaximumSize(properties.getMemoryMaximumSize());
        params.setNojavac(properties.isNoJavac());
        params.setQuiet(properties.isQuiet());
        params.setVerbose(properties.isVerbose());
        params.setDownload(properties.isDownload());
        params.setNoUpa(properties.isNoUpa());
        params.setNoPvr(properties.isNoPvr());
        params.setDebug(properties.isDebug());
        if (properties.hasCatalogFile()) {
            CatalogManager catalogManager = CatalogManager.getStaticManager();
            catalogManager.setCatalogFiles(properties.getCatalogFile());
            Object entityResolver = new CatalogResolver();
            URI sourceDirURI = properties.getBaseDir().toURI();
            entityResolver = new PassThroughResolver((EntityResolver)entityResolver);
            params.setEntityResolver((EntityResolver)entityResolver);
        }
        params.setErrorListener(properties.getErrorListeners());
        params.setRepackage(properties.getRepackage());
        params.setExtensions(properties.getExtensions());
        params.setMdefNamespaces(properties.getMdefNamespaces());
        params.setJavaSource(properties.getJavaSource());
        return params;
    }

    private static class PassThroughResolver
    implements EntityResolver {
        private final EntityResolver delegate;

        public PassThroughResolver(EntityResolver delegate) {
            this.delegate = delegate;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            InputSource is;
            if (this.delegate != null && (is = this.delegate.resolveEntity(publicId, systemId)) != null) {
                return is;
            }
            System.out.println("Could not resolve publicId: " + publicId + ", systemId: " + systemId + " from catalog, looking in current directory");
            return new InputSource(systemId);
        }
    }
}

