/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exception;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.exception.Error;

public abstract class CodedException
extends MojoExecutionException {
    protected static final Error MISSING_ERROR_KEY = new Error("missing.error.key");
    protected Error error;
    protected String[] errorFields;
    protected ResourceBundle errors = null;

    public CodedException() {
        super("");
        this.init(null, null);
    }

    public CodedException(Error code) {
        super("");
        this.init(code, null);
    }

    public CodedException(Error code, String[] fields) {
        super("");
        this.init(code, fields);
    }

    public CodedException(Error code, String field) {
        super("");
        String[] fields = new String[]{field};
        this.init(code, fields);
    }

    public CodedException(Error code, Throwable exception) {
        super("", (Exception)exception);
        this.init(code, null);
    }

    public CodedException(Error code, String field, Throwable exception) {
        super("", (Exception)exception);
        String[] fields = new String[]{field};
        this.init(code, fields);
    }

    public CodedException(Error code, String[] fields, Throwable exception) {
        super("", (Exception)exception);
        this.init(code, fields);
    }

    protected final void init(Error code, String[] fields) {
        if (code != null) {
            this.error = code;
        }
        this.errorFields = fields;
    }

    public final String getMessage() {
        String message = null;
        if (this.errors != null && this.error != null) {
            try {
                message = this.errors.getString(this.error.toString());
                if (this.errorFields != null) {
                    message = MessageFormat.format(message, this.errorFields);
                }
            }
            catch (MissingResourceException e) {
                message = this.errors.getString(MISSING_ERROR_KEY.getErrorKey() + ":" + e.getKey());
            }
        } else {
            message = "An unknown error occurred.";
        }
        return message;
    }
}

