/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.codehaus.mojo.xml.LSInputImpl;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.EntityResolver2;

public class Resolver
implements EntityResolver2,
URIResolver,
LSResourceResolver {
    private final File baseDir;
    private final CatalogResolver resolver;
    private boolean validating;

    Resolver(File pBaseDir, File[] pFiles) throws MojoExecutionException {
        this.baseDir = pBaseDir;
        CatalogManager manager = new CatalogManager();
        manager.setIgnoreMissingProperties(true);
        this.resolver = new CatalogResolver(manager);
        for (int i = 0; i < pFiles.length; ++i) {
            try {
                this.resolver.getCatalog().parseCatalog(pFiles[i].toURI().toURL().toExternalForm());
                continue;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to parse catalog file: " + pFiles[i].getPath() + ": " + e.getMessage(), (Exception)e);
            }
        }
    }

    public InputSource resolveEntity(String pPublicId, String pSystemId) throws SAXException, IOException {
        URL url = this.resolve(pSystemId);
        if (url != null) {
            return this.asInputSource(url);
        }
        return this.resolver.resolveEntity(pPublicId, pSystemId);
    }

    private InputSource asInputSource(URL url) throws IOException {
        InputSource isource = new InputSource(url.openStream());
        isource.setSystemId(url.toExternalForm());
        return isource;
    }

    public Source resolve(String pHref, String pBase) throws TransformerException {
        URL url = this.resolve(pHref);
        if (url != null) {
            try {
                return new SAXSource(this.asInputSource(url));
            }
            catch (IOException e) {
                throw new TransformerException(e);
            }
        }
        Source source = this.resolver.resolve(pHref, pBase);
        if (source == null) {
            return source;
        }
        InputSource isource = SAXSource.sourceToInputSource(source);
        if (isource == null) {
            return source;
        }
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setValidating(this.validating);
            spf.setNamespaceAware(true);
            XMLReader xmlReader = spf.newSAXParser().getXMLReader();
            xmlReader.setEntityResolver(this);
            return new SAXSource(xmlReader, isource);
        }
        catch (ParserConfigurationException e) {
            throw new TransformerException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new TransformerException(e.getMessage(), e);
        }
    }

    public LSInput resolveResource(String pType, String pNamespaceURI, String pPublicId, String pSystemId, String pBaseURI) {
        InputSource isource;
        URL url = this.resolve(pSystemId);
        if (url != null) {
            try {
                isource = this.asInputSource(url);
            }
            catch (IOException e) {
                throw new UndeclaredThrowableException(e);
            }
        } else {
            isource = this.resolver.resolveEntity(pPublicId, pSystemId);
            if (isource == null) {
                return null;
            }
        }
        LSInputImpl result = new LSInputImpl();
        result.setByteStream(isource.getByteStream());
        result.setCharacterStream(isource.getCharacterStream());
        result.setPublicId(isource.getPublicId());
        result.setSystemId(isource.getSystemId());
        result.setEncoding(isource.getEncoding());
        return result;
    }

    public void setValidating(boolean pValidating) {
        this.validating = pValidating;
    }

    public boolean isValidating() {
        return this.validating;
    }

    private URL resolveAsResource(String pResource) {
        return Thread.currentThread().getContextClassLoader().getResource(pResource);
    }

    private URL resolveAsFile(String pResource) {
        File f = new File(this.baseDir, pResource);
        if (!f.isFile() && !(f = new File(pResource)).isFile()) {
            return null;
        }
        try {
            return f.toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL resolveAsURL(String pResource) {
        InputStream stream = null;
        try {
            URL url = new URL(pResource);
            stream = url.openStream();
            stream.close();
            stream = null;
            URL uRL = url;
            return uRL;
        }
        catch (IOException e) {
            URL uRL = null;
            return uRL;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    public URL resolve(String pResource) {
        if (pResource == null) {
            return null;
        }
        if (pResource.startsWith("resource:")) {
            String res = pResource.substring("resource:".length());
            return this.resolveAsResource(res);
        }
        URL url = this.resolveAsResource(pResource);
        if (url == null && (url = this.resolveAsURL(pResource)) == null) {
            url = this.resolveAsFile(pResource);
        }
        return url;
    }

    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        return null;
    }

    public InputSource resolveEntity(String pName, String pPublicId, String pBaseURI, String pSystemId) throws SAXException, IOException {
        URL url = this.resolve(pSystemId);
        if (url != null) {
            return this.asInputSource(url);
        }
        return this.resolver.resolveEntity(pPublicId, pSystemId);
    }
}

