/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.xdoclet;

import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.antrun.AbstractAntMojo;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.taskdefs.Taskdef;
import org.codehaus.classworlds.ClassRealm;

public class XDocletMojo
extends AbstractAntMojo {
    private static final String XDOCLET_CP = "xdoclet.class.path";
    private MavenProject project;
    private String sourceDirectory;
    private String generatedSourcesDirectory;
    private Target tasks;
    private ClassRealm classRealm;
    private boolean isInitialized = false;

    public void execute() throws MojoExecutionException {
        String oldXDocletClasspath = System.getProperty(XDOCLET_CP);
        try {
            System.setProperty(XDOCLET_CP, this.createClasspath());
            this.initializeDocletMappings();
            this.executeTasks(this.tasks, this.project);
            this.project.addCompileSourceRoot(this.generatedSourcesDirectory);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error", e);
        }
        finally {
            if (oldXDocletClasspath == null) {
                ((Hashtable)System.getProperties()).remove(XDOCLET_CP);
            } else {
                System.setProperty(XDOCLET_CP, oldXDocletClasspath);
            }
        }
    }

    private String createClasspath() {
        URL[] cpe = this.classRealm.getConstituents();
        String classpath = "";
        for (int i = 0; i < cpe.length; ++i) {
            classpath = classpath + (classpath.length() == 0 ? "" : File.pathSeparator) + cpe[i].getFile();
        }
        return classpath;
    }

    private void initializeDocletMappings() {
        if (this.isInitialized) {
            this.getLog().info((CharSequence)"TaskDefinitions already in place");
            return;
        }
        this.getLog().info((CharSequence)"Initializing DocletTasks!!!");
        String[] mappings = new String[]{"doclet", "xdoclet.DocletTask", "tapestrydoclet", "xdoclet.modules.apache.tapestry.TapestryDocletTask", "docdoclet", "xdoclet.modules.doc.DocumentDocletTask", "ejbdoclet", "xdoclet.modules.ejb.EjbDocletTask", "hibernatedoclet", "xdoclet.modules.hibernate.HibernateDocletTask", "jdodoclet", "xdoclet.modules.jdo.JdoDocletTask", "jmxdoclet", "xdoclet.modules.jmx.JMXDocletTask", "mockdoclet", "xdoclet.modules.mockobjects.MockObjectDocletTask", "portletdoclet", "xdoclet.modules.portlet.PortletDocletTask", "springdoclet", "xdoclet.modules.spring.SpringDocletTask", "webdoclet", "xdoclet.modules.web.WebDocletTask", "wseedoclet", "xdoclet.modules.wsee.WseeDocletTask"};
        for (int i = 0; i < mappings.length; i += 2) {
            Taskdef taskDef = new Taskdef();
            taskDef.setProject(this.tasks.getProject());
            taskDef.setName(mappings[i]);
            taskDef.setClassname(mappings[i + 1]);
            taskDef.setOwningTarget(this.tasks);
            taskDef.perform();
        }
        this.isInitialized = true;
    }
}

