/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.verify;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.verify.AbstractVerifyFormStep;
import com.canoo.webtest.util.ConversionUtil;
import com.canoo.webtest.util.FormUtil;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import java.io.IOException;
import java.util.List;

public class VerifyInputField
extends AbstractVerifyFormStep {
    private String fRegex;

    public String getRegex() {
        return this.fRegex;
    }

    public void setRegex(String regex) {
        this.fRegex = regex;
    }

    protected HtmlForm findForm() {
        return FormUtil.findFormForField(this.getContext(), this.getFormName(), "input", null, this.getName(), this);
    }

    protected List findFields(HtmlForm form) {
        return form.getInputsByName(this.getName());
    }

    protected void verifyField(HtmlElement field) throws IOException {
        HtmlInput input = (HtmlInput)field;
        String fieldContents = input.getValueAttribute();
        if (!VerifyInputField.verifyStrings(this.getValue(), fieldContents, this.getRegex())) {
            throw new StepFailedException("Wrong contents found in input field: " + input, this.getValue(), fieldContents);
        }
    }

    private static boolean verifyStrings(String expectedValue, String actualValue, String regex) {
        return VerifyInputField.getVerifier(ConversionUtil.convertToBoolean(regex, false)).verifyStrings(expectedValue, actualValue);
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.paramCheck(this.isValueNull(), "Required parameter \"value\" not set!");
    }
}

