/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.control;

import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.engine.xpath.XPathHelper;
import com.canoo.webtest.steps.control.MultipleExecutionStepContainer;
import java.util.List;
import java.util.ListIterator;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathException;
import org.apache.log4j.Logger;
import org.apache.tools.ant.Task;

public class RepeatStep
extends MultipleExecutionStepContainer {
    private static final Logger LOG = Logger.getLogger(RepeatStep.class);
    private static final String DEFAULT_COUNTERNAME = "count";
    private Integer fCount;
    private int fStartCount;
    private Integer fEndCount;
    private int fStep = 1;
    private String fCounterName = "count";
    private String fXpath;

    public void setCount(Integer count) {
        this.fCount = count;
    }

    public Integer getCount() {
        return this.fCount;
    }

    public void setStartCount(int count) {
        this.fStartCount = count;
    }

    public int getStartCount() {
        return this.fStartCount;
    }

    public void setEndCount(Integer count) {
        this.fEndCount = count;
    }

    public Integer getEndCount() {
        return this.fEndCount;
    }

    public void setStep(int step) {
        this.fStep = step;
    }

    public int getStep() {
        return this.fStep;
    }

    public void setCounterName(String counterName) {
        this.fCounterName = counterName;
    }

    public String getCounterName() {
        return this.fCounterName;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        if (this.getStep() < 1) {
            throw new StepExecutionException("Step must be greater than or equal to 1!", this);
        }
        if (this.getCount() != null) {
            if (this.getCount() < 0) {
                throw new StepExecutionException("Repeat count must be greater than or equal to 0!", this);
            }
        } else if (this.getEndCount() != null) {
            if (this.getEndCount() < this.fStartCount) {
                throw new StepExecutionException("endCount (" + this.fEndCount + ") must be greater than or equal to startCount (" + this.fStartCount + ")!", this);
            }
        } else if (this.getXpath() == null) {
            throw new StepExecutionException("You must specify a count, a endCount or a XPath attribute.", this);
        }
    }

    public void doExecute() throws XPathException {
        if (this.getXpath() != null) {
            this.doExecuteWithXPath();
        } else {
            int first = this.getStartCount();
            int last = this.getCount() != null ? first + this.getCount() : this.getEndCount() + 1;
            for (int i = first; i < last; i += this.getStep()) {
                this.setWebtestProperty(this.getCounterName(), Integer.toString(i));
                this.executeContainedTasks(String.valueOf(i));
            }
        }
    }

    protected List getNodesByXPath() throws XPathException {
        return this.getContext().getXPathHelper().selectNodes(this.getContext().getCurrentResponse(), this.getXpath());
    }

    protected void doExecuteWithXPath() throws XPathException {
        LOG.debug((Object)("repeat with xpath " + this.getXpath()));
        XPathHelper xpathHelper = this.getContext().getXPathHelper();
        List nodes = this.getNodesByXPath();
        int nbNodes = nodes.size();
        LOG.debug((Object)("Iterating over " + nbNodes + " nodes"));
        ListIterator iter = nodes.listIterator();
        while (iter.hasNext()) {
            Object node = iter.next();
            String loopLabel = iter.nextIndex() + "/" + nbNodes;
            LOG.debug((Object)("Iteration " + loopLabel + ": placing current node >" + node + "< as >" + this.getCounterName() + "< in variable context"));
            xpathHelper.getVariableContext().setVariableValue(new QName(this.getCounterName()), node);
            this.executeContainedTasks(loopLabel);
        }
    }

    protected void executeContainedTasks(String loopLabel) {
        LOG.debug((Object)("creating wrapper for current iteration (" + this.getCounterName() + "): " + loopLabel));
        Task iterationWrapper = this.createIterationWrapper("Iteration " + loopLabel);
        LOG.debug((Object)("execution wrapper for current iteration (" + this.getCounterName() + "): " + loopLabel));
        iterationWrapper.perform();
    }

    public String getXpath() {
        return this.fXpath;
    }

    public void setXpath(String xpath) {
        this.fXpath = xpath;
    }
}

