/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.pdftest;

import com.canoo.webtest.engine.ContextHelper;
import com.canoo.webtest.plugins.pdftest.AbstractPdfFilter;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFFont;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFPage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class PdfToFontsFilter
extends AbstractPdfFilter {
    protected void doFilter(PDFPage pdfPage) {
        String content = PdfToFontsFilter.fontsToString(pdfPage.getFonts());
        ContextHelper.defineAsCurrentResponse(this.getContext(), content, "text/plain", "http:" + this.getClass().getName());
    }

    static String fontsToString(List _fonts) {
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i < _fonts.size(); ++i) {
            PDFFont font = (PDFFont)_fonts.get(i);
            strings.add(font.getPage() + "|" + font.getType() + "|" + font.getName());
        }
        Collections.sort(strings);
        String lineSep = System.getProperty("line.separator");
        return StringUtils.join(strings, (String)lineSep);
    }
}

