/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.exceltest;

import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.plugins.exceltest.AbstractExcelCellStep;
import com.canoo.webtest.plugins.exceltest.ExcelCellUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.util.CellReference;

public class ExcelVerifyCellSum
extends AbstractExcelCellStep {
    private String fRange;

    public String getRange() {
        return this.fRange;
    }

    public void setRange(String range) {
        this.fRange = range;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullParamCheck(this.getRange(), "range");
        if (!this.getRange().matches("[A-Za-z]+[0-9]+:[A-Za-z]+[0-9]+")) {
            throw new StepExecutionException("Cannot parse \"" + this.getRange() + "\" as a spreadsheet range. eg \"A10:A20\"", this);
        }
    }

    public void doExecute() throws Exception {
        HSSFCell excelCell = this.getExcelCell();
        this.checkFormula(excelCell);
        this.checkLiteralValue(excelCell);
    }

    private void checkFormula(HSSFCell excelCell) {
        if (excelCell.getCellType() == 2) {
            String actualValue;
            String expectedValue = "SUM(" + this.getRange() + ")".toUpperCase();
            if (this.verifyStrings(expectedValue, actualValue = excelCell.getCellFormula().toUpperCase())) {
                return;
            }
            throw new StepFailedException("Unexpected formula in cell " + this.getCellReferenceStr(), expectedValue, actualValue);
        }
        if (excelCell.getCellType() != 0) {
            throw new StepFailedException("Cell " + this.getCellReferenceStr() + " does not contain a formula or a numeric value.");
        }
    }

    private void checkLiteralValue(HSSFCell excelCell) {
        double cellValue = excelCell.getNumericCellValue();
        int colon = this.getRange().indexOf(58);
        CellReference start = ExcelCellUtils.getCellReference(this, this.getRange().substring(0, colon));
        CellReference end = ExcelCellUtils.getCellReference(this, this.getRange().substring(colon + 1));
        double sum = 0.0;
        for (int row = start.getRow(); row <= end.getRow(); ++row) {
            for (short col = start.getCol(); col <= end.getCol(); col = (short)(col + 1)) {
                HSSFCell excelCellAt = ExcelCellUtils.getExcelCellAt(this, row, col);
                if (excelCellAt == null || excelCellAt.getCellType() == 3) continue;
                if (excelCellAt.getCellType() == 0) {
                    sum += excelCellAt.getNumericCellValue();
                    continue;
                }
                throw new StepFailedException("Cell " + (char)(65 + col) + (row + 1) + " does not contain a numeric value.");
            }
        }
        if (Math.abs(cellValue - sum) > 0.01) {
            throw new StepFailedException("Unexpected sum of cells from range " + this.fRange + " in cell " + this.getCellReferenceStr(), String.valueOf(sum), String.valueOf(cellValue));
        }
    }
}

