/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.exceltest;

import com.canoo.webtest.engine.ContextHelper;
import com.canoo.webtest.interfaces.IContentFilter;
import com.canoo.webtest.plugins.exceltest.AbstractExcelStep;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExcelStructureFilter
extends AbstractExcelStep
implements IContentFilter {
    public void doExecute() throws Exception {
        HSSFWorkbook excelWorkbook = this.getExcelWorkbook();
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.newDocument();
        Element root = doc.createElement("excelWorkbook");
        doc.appendChild(root);
        root.setAttribute("backup", String.valueOf(excelWorkbook.getBackupFlag()));
        root.setAttribute("numberOfFonts", String.valueOf(excelWorkbook.getNumberOfFonts()));
        root.setAttribute("numberOfCellStyles", String.valueOf(excelWorkbook.getNumCellStyles()));
        root.setAttribute("numberOfNames", String.valueOf(excelWorkbook.getNumberOfNames()));
        Element sheets = doc.createElement("sheets");
        for (int i = 0; i < excelWorkbook.getNumberOfSheets(); ++i) {
            HSSFSheet sheetAt = excelWorkbook.getSheetAt(i);
            Element sheetElement = doc.createElement("sheet");
            sheetElement.setAttribute("index", String.valueOf(i));
            sheetElement.setAttribute("name", excelWorkbook.getSheetName(i));
            sheetElement.setAttribute("firstRow", String.valueOf(sheetAt.getFirstRowNum()));
            sheetElement.setAttribute("lastRow", String.valueOf(sheetAt.getLastRowNum()));
            sheetElement.setAttribute("physicalRows", String.valueOf(sheetAt.getPhysicalNumberOfRows()));
            sheetElement.setAttribute("defaultRowHeight", String.valueOf(sheetAt.getDefaultRowHeight()));
            sheetElement.setAttribute("defaultColumnWidth", String.valueOf(sheetAt.getDefaultColumnWidth()));
            sheetElement.setAttribute("fitToPage", String.valueOf(sheetAt.getFitToPage()));
            sheets.appendChild(sheetElement);
        }
        root.appendChild(sheets);
        StringWriter sw = new StringWriter();
        this.writeXmlFile(doc, sw);
        ContextHelper.defineAsCurrentResponse(this.getContext(), sw.toString(), "text/xml", "http:" + this.getClass().getName());
    }

    protected void writeXmlFile(Document doc, Writer writer) throws IOException {
        OutputFormat format = new OutputFormat(doc);
        format.setIndenting(true);
        format.setEncoding("ISO-8859-1");
        format.setLineWidth(50);
        XMLSerializer serializer = new XMLSerializer(writer, format);
        serializer.asDOMSerializer();
        serializer.serialize(doc.getDocumentElement());
        writer.close();
    }
}

