/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.exceltest;

import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.plugins.exceltest.AbstractExcelSheetStep;
import com.canoo.webtest.plugins.exceltest.ExcelCellUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.util.CellReference;

public abstract class AbstractExcelCellStep
extends AbstractExcelSheetStep {
    private String fRow;
    private String fCol;
    private String fCell;

    public void setCell(String cell) {
        this.fCell = cell;
    }

    public String getCell() {
        return this.fCell;
    }

    public void setRow(String row) {
        this.fRow = row;
    }

    public String getRow() {
        return this.fRow;
    }

    public void setCol(String col) {
        this.fCol = col;
    }

    public String getCol() {
        return this.fCol;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        if (this.getCell() == null && (this.getRow() == null || this.getCol() == null)) {
            throw new StepExecutionException("You must specify a row and column or a cell reference.", this);
        }
        if (this.getCell() != null && (this.getRow() != null || this.getCol() != null)) {
            throw new StepExecutionException("You must specify either a row and column or a cell reference.", this);
        }
    }

    protected HSSFCell getExcelCell() {
        CellReference cellReference = ExcelCellUtils.getCellReference(this, this.getCell(), this.getRow(), this.getCol());
        return ExcelCellUtils.getExcelCellAt(this, cellReference.getRow(), cellReference.getCol());
    }

    protected String getCellValue() {
        return ExcelCellUtils.getCellValueAt(this.getExcelCell());
    }

    protected CellReference getCellReference() {
        return ExcelCellUtils.getCellReference(this, this.getCell(), this.getRow(), this.getCol());
    }

    protected String getCellReferenceStr() {
        return this.getCellReference().formatAsString();
    }
}

