/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension.spider;

import com.canoo.webtest.extension.spider.PatternVisitorStrategy;
import com.canoo.webtest.extension.spider.SeparatedValueReporter;
import com.canoo.webtest.extension.spider.SimpleLinksValidator;
import com.canoo.webtest.extension.spider.Spider;
import com.canoo.webtest.steps.Step;
import java.io.IOException;
import org.apache.oro.text.perl.Perl5Util;
import org.xml.sax.SAXException;

public class ReportLinksStep
extends Step {
    public static final String[] HEADERS = new String[]{"Depth", "Label", "Class", "Title", "Href"};
    static final Perl5Util PERL = new Perl5Util();
    public static final String PATTERN_MENU_ID = "m/.*/";
    private String fFileName;
    private int fDepth;
    private String fVisitPattern = "m/.*/";

    public void setVisitPattern(String visitPattern) {
        this.fVisitPattern = visitPattern;
    }

    public void setFile(String filename) {
        this.fFileName = filename;
    }

    public void setDepth(int depth) {
        this.fDepth = depth;
    }

    public void doExecute() throws SAXException, IOException {
        Spider spider = new Spider();
        spider.setDepth(this.fDepth);
        spider.setFileName(this.fFileName);
        spider.setReporter(new SeparatedValueReporter(HEADERS));
        spider.setVisitorStrategy(new PatternVisitorStrategy(this.fVisitPattern));
        spider.setValidator(new SimpleLinksValidator());
        spider.execute(this.getContext());
    }
}

