/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.engine;

import com.canoo.webtest.ant.WebtestTask;
import com.canoo.webtest.boundary.ResetScriptRunner;
import com.canoo.webtest.engine.Configuration;
import com.canoo.webtest.engine.WebClientContext;
import com.canoo.webtest.engine.xpath.XPathHelper;
import com.canoo.webtest.steps.Step;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context {
    private static final Logger LOG = Logger.getLogger(Context.class);
    public static final String KEY_DEFAULT_WEBCLIENTCONTEXT = "default";
    private int fCurrentStepIndex;
    private WebtestTask fWebtest;
    private boolean fPrepared;
    private Map<String, Object> fContextStore = new HashMap<String, Object>();
    private ResetScriptRunner fSavedRunner;
    private final XPathHelper fXPathHelper = new XPathHelper();
    private WebClientContext fCurrentWebClientContext = new WebClientContext("default");
    private final Map<String, WebClientContext> fWebClientContexts = new HashMap<String, WebClientContext>();
    private final AtomicReference<ScriptException> backgroundJSError_ = new AtomicReference();

    public Context(WebtestTask webtest) {
        this.fWebtest = webtest;
        this.fWebClientContexts.put(KEY_DEFAULT_WEBCLIENTCONTEXT, this.fCurrentWebClientContext);
    }

    public boolean containsKey(String key) {
        return this.fContextStore.containsKey(key);
    }

    public Object get(String key) {
        return this.fContextStore.get(key);
    }

    public Configuration getConfig() {
        return this.getWebtest().getConfig();
    }

    public HtmlForm getCurrentForm() {
        return this.getCurrentWebClientContext().getCurrentForm();
    }

    public HtmlPage getCurrentHtmlResponse(Step step) {
        return this.getCurrentWebClientContext().getCurrentHtmlResponse(step);
    }

    public Page getCurrentResponse() {
        return this.getCurrentWebClientContext().getCurrentResponse();
    }

    public String getCurrentResponseFile() {
        return this.getCurrentWebClientContext().getCurrentResponseFile();
    }

    public int getCurrentStepNumber() {
        return this.fCurrentStepIndex + 1;
    }

    public WebClientContext getCurrentWebClientContext() {
        return this.fCurrentWebClientContext;
    }

    public int getNumberOfSteps() {
        return this.getWebtest().getStepSequence().getSteps().size();
    }

    public Map<String, WebClientContext> getWebClientContexts() {
        return Collections.unmodifiableMap(this.fWebClientContexts);
    }

    public WebClientContext defineCurrentWebClientContext(String name) {
        WebClientContext webClientContext = this.fWebClientContexts.get(name);
        if (webClientContext == null) {
            webClientContext = new WebClientContext(name);
            webClientContext.setWebClient(this.getConfig().createWebClient());
            this.fWebClientContexts.put(name, webClientContext);
            LOG.info((Object)("Created new WebClientContext for \"" + name + "\""));
        }
        this.fCurrentWebClientContext = webClientContext;
        return webClientContext;
    }

    public WebClientContext.StoredResponses getResponses() {
        return this.getCurrentWebClientContext().getResponses();
    }

    public ResetScriptRunner getRunner() {
        return this.fSavedRunner;
    }

    public String getSavedPassword() {
        return this.getCurrentWebClientContext().getSavedPassword();
    }

    public String getSavedUserName() {
        return this.getCurrentWebClientContext().getSavedUserName();
    }

    public WebClient getWebClient() {
        return this.getCurrentWebClientContext().getWebClient();
    }

    public WebtestTask getWebtest() {
        return this.fWebtest;
    }

    public XPathHelper getXPathHelper() {
        return this.fXPathHelper;
    }

    public void increaseStepNumber() {
        ++this.fCurrentStepIndex;
    }

    public boolean isPrepared() {
        return this.fPrepared;
    }

    public void put(String key, Object value) {
        LOG.debug((Object)("put(" + key + ", " + value + ")"));
        this.fContextStore.put(key, value);
    }

    public void remove(String key) {
        this.fContextStore.remove(key);
    }

    public void restorePreviousResponse() {
        this.getCurrentWebClientContext().restorePreviousResponse();
    }

    public void restoreResponses(WebClientContext.StoredResponses savedResponses) {
        this.getCurrentWebClientContext().restoreResponses(savedResponses);
    }

    public void restoreWindowListener() {
        this.getCurrentWebClientContext().restoreWindowListener();
    }

    public void saveResponseAsCurrent(Page page) {
        this.getCurrentWebClientContext().saveResponseAsCurrent(page);
    }

    public void setCurrentForm(HtmlForm form) {
        this.getCurrentWebClientContext().setCurrentForm(form);
    }

    public void setPrepared(boolean prepared) {
        this.fPrepared = prepared;
    }

    public void setRunner(ResetScriptRunner sr) {
        this.fSavedRunner = sr;
    }

    public void setSavedPassword(String password) {
        this.getCurrentWebClientContext().setSavedPassword(password);
    }

    public void setSavedUserName(String userName) {
        this.getCurrentWebClientContext().setSavedUserName(userName);
    }

    public void setWebClient(WebClient webClient) {
        this.getCurrentWebClientContext().setWebClient(webClient);
    }

    public void suspendWindowListener() {
        this.getCurrentWebClientContext().suspendWindowListener();
    }

    public ScriptException getBackgroundJSError() {
        return this.backgroundJSError_.getAndSet(null);
    }

    public void setBackgroundJSError(ScriptException e) {
        this.backgroundJSError_.set(e);
    }
}

