/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.engine;

import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.util.WebConnectionWrapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVTracingWebConnection
extends WebConnectionWrapper {
    private int counter = 0;
    private final WebConnection wrappedWebConnection_;
    private final OutputStreamWriter fileWriter_;

    public CSVTracingWebConnection(WebConnection webConnection, File resultFile) throws IOException {
        super(webConnection);
        this.wrappedWebConnection_ = webConnection;
        this.fileWriter_ = new OutputStreamWriter((OutputStream)new FileOutputStream(resultFile), "UTF-8");
        this.writeHeaders();
    }

    protected void writeHeaders() throws IOException {
        this.appendToResultFile(this.toCSV(this.getHeaders()) + "\n");
    }

    public WebResponse getResponse(WebRequest request) throws IOException {
        WebResponse response = this.wrappedWebConnection_.getResponse(request);
        this.traceRequest(request, response);
        return response;
    }

    protected synchronized void traceRequest(WebRequest request, WebResponse response) throws IOException {
        Iterable<String> info = this.getInformation(response, request);
        this.appendToResultFile(this.toCSV(info) + "\n");
    }

    protected Iterable<String> getInformation(WebResponse response, WebRequest request) {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add(String.valueOf(++this.counter));
        fields.add(request.getHttpMethod().name());
        fields.add(request.getUrl().toString());
        fields.add(String.valueOf(response.getStatusCode()));
        fields.add(response.getStatusMessage());
        fields.add(response.getContentType());
        fields.add(String.valueOf(response.getLoadTime()));
        return fields;
    }

    protected Iterable<String> getHeaders() {
        String[] headers = new String[]{"#", "Method", "URL", "Response code", "Response Message", "Content Type", "Duration"};
        return Arrays.asList(headers);
    }

    protected String toCSV(Iterable<String> values) {
        StringBuilder sb = new StringBuilder();
        for (String s : values) {
            sb.append(";");
            sb.append(s);
        }
        sb.deleteCharAt(0);
        return sb.toString();
    }

    protected void appendToResultFile(String str) throws IOException {
        this.fileWriter_.write(str);
        this.fileWriter_.flush();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.fileWriter_.close();
    }
}

