package org.codehaus.mojo.webstart;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on webstart-maven-plugin.<br/> Call <pre>  mvn webstart:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Thu Sep 15 17:50:19 CEST 2011
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.7)
 * @goal help
 * @requiresProject false
 * @threadSafe
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo.webstart:webstart-maven-plugin:1.0-beta-2", 0 );
        append( sb, "", 0 );

        append( sb, "MWEBSTART :: Webstart Maven Plugin", 0 );
        append( sb, "Maven plugin that supports webstart application development. Helps generate JNLP files and supports the JnlpDownloadServlet.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 7 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "webstart:help", 0 );
            append( sb, "Display help information on webstart-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0webstart:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "Expression: ${detail}", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "Expression: ${goal}", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "Expression: ${indentSize}", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "Expression: ${lineLength}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "jnlp".equals( goal ) )
        {
            append( sb, "webstart:jnlp", 0 );
            append( sb, "Packages a jnlp application.\nThe plugin tries to not re-sign\nre-pack if the dependent jar hasn\'t changed. As a consequence, if one modifies the pom jnlp config or a keystore, one should clean before rebuilding.\nThis mojo forks a build lifecycle and won\'t install the zip packages in your local repository. You probably want to use the jnlp-inline instead.\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "attachArchive (Default: true)", 2 );
                append( sb, "Flag to attach the archive or not to the project\'s build.", 3 );
                append( sb, "", 0 );

                append( sb, "canUnsign (Default: true)", 2 );
                append( sb, "To authorize or not to unsign some already signed jar.\nIf set to false and the unsign parameter is set to true then the build will fail if there is a jar to unsign, to avoid this use then the extension jnlp component.\n", 3 );
                append( sb, "", 0 );

                append( sb, "codebase (Default: ${project.url}/jnlp)", 2 );
                append( sb, "The code base to use on the generated jnlp files.", 3 );
                append( sb, "Expression: ${jnlp.codebase}", 3 );
                append( sb, "", 0 );

                append( sb, "dependencies", 2 );
                append( sb, "[optional] transitive dependencies filter - if omitted, the plugin will include all transitive dependencies. Provided and test scope dependencies are always excluded.", 3 );
                append( sb, "", 0 );

                append( sb, "excludeTransitive", 2 );
                append( sb, "Set to true to exclude all transitive dependencies.", 3 );
                append( sb, "", 0 );

                append( sb, "gzip (Default: false)", 2 );
                append( sb, "Indicates whether or not gzip archives will be created for each of the jar files included in the webstart bundle.", 3 );
                append( sb, "", 0 );

                append( sb, "jnlp", 2 );
                append( sb, "The jnlp configuration element.", 3 );
                append( sb, "", 0 );

                append( sb, "jnlpExtensions", 2 );
                append( sb, "[optional] extensions configuration.", 3 );
                append( sb, "", 0 );

                append( sb, "keystore", 2 );
                append( sb, "A placeholder for an obsoleted configuration element.\nThis dummy parameter is here to force the plugin configuration to fail in case one didn\'t properly migrate from 1.0-alpha-1 to 1.0-alpha-2 configuration.\n\nIt will be removed before 1.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "libPath", 2 );
                append( sb, "The path where the libraries are placed within the jnlp structure.", 3 );
                append( sb, "", 0 );

                append( sb, "makeArchive (Default: true)", 2 );
                append( sb, "Flag to create the archive or not.", 3 );
                append( sb, "", 0 );

                append( sb, "outputJarVersions (Default: false)", 2 );
                append( sb, "When set to true, this flag indicates that a version attribute should be output in each of the jar resource elements in the generated JNLP file.", 3 );
                append( sb, "", 0 );

                append( sb, "pack200 (Default: false)", 2 );
                append( sb, "Indicates whether or not jar resources should be compressed using pack200. Setting this value to true requires SDK 5.0 or greater.", 3 );
                append( sb, "", 0 );

                append( sb, "resourcesDirectory", 2 );
                append( sb, "The location of the directory (relative or absolute) containing non-jar resources that are to be included in the JNLP bundle.", 3 );
                append( sb, "", 0 );

                append( sb, "sign", 2 );
                append( sb, "The Sign Config", 3 );
                append( sb, "", 0 );

                append( sb, "templateDirectory (Default: ${project.basedir}/src/main/jnlp)", 2 );
                append( sb, "The location where the JNLP Velocity template files are stored.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "unsignAlreadySignedJars (Default: false)", 2 );
                append( sb, "Define whether to remove existing signatures.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Enable verbose output.", 3 );
                append( sb, "Expression: ${verbose}", 3 );
                append( sb, "", 0 );

                append( sb, "verifyjar (Default: true)", 2 );
                append( sb, "Indicates whether or not jar files should be verified after signing.", 3 );
                append( sb, "", 0 );

                append( sb, "workDirectory (Default: ${project.build.directory}/jnlp)", 2 );
                append( sb, "The directory in which files will be stored prior to processing.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "jnlp-download-servlet".equals( goal ) )
        {
            append( sb, "webstart:jnlp-download-servlet", 0 );
            append( sb, "This MOJO is tailored for use within a Maven web application project that uses the JnlpDownloadServlet to serve up the JNLP application.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "attachArchive (Default: true)", 2 );
                append( sb, "Flag to attach the archive or not to the project\'s build.", 3 );
                append( sb, "", 0 );

                append( sb, "canUnsign (Default: true)", 2 );
                append( sb, "To authorize or not to unsign some already signed jar.\nIf set to false and the unsign parameter is set to true then the build will fail if there is a jar to unsign, to avoid this use then the extension jnlp component.\n", 3 );
                append( sb, "", 0 );

                append( sb, "codebase (Default: ${project.url}/jnlp)", 2 );
                append( sb, "The code base to use on the generated jnlp files.", 3 );
                append( sb, "Expression: ${jnlp.codebase}", 3 );
                append( sb, "", 0 );

                append( sb, "commonJarResources", 2 );
                append( sb, "The configurable collection of jars that are common to all jnlpFile elements declared in plugin configuration. These jars will be output as jar elements in the resources section of every generated JNLP file and bundled into the specified output directory of the artifact produced by the project.", 3 );
                append( sb, "", 0 );

                append( sb, "excludeTransitive", 2 );
                append( sb, "Set to true to exclude all transitive dependencies.", 3 );
                append( sb, "", 0 );

                append( sb, "gzip (Default: false)", 2 );
                append( sb, "Indicates whether or not gzip archives will be created for each of the jar files included in the webstart bundle.", 3 );
                append( sb, "", 0 );

                append( sb, "jnlpFiles", 2 );
                append( sb, "The collection of JnlpFile configuration elements. Each one represents a JNLP file that is to be generated and deployed within the enclosing project\'s WAR artifact. At least one JnlpFile must be specified.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "libPath", 2 );
                append( sb, "The path where the libraries are placed within the jnlp structure.", 3 );
                append( sb, "", 0 );

                append( sb, "makeArchive (Default: true)", 2 );
                append( sb, "Flag to create the archive or not.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectoryName (Default: webstart)", 2 );
                append( sb, "The name of the directory into which the jnlp file and other artifacts will be stored after processing. This directory will be created directly within the root of the WAR produced by the enclosing project.", 3 );
                append( sb, "", 0 );

                append( sb, "pack200 (Default: false)", 2 );
                append( sb, "Indicates whether or not jar resources should be compressed using pack200. Setting this value to true requires SDK 5.0 or greater.", 3 );
                append( sb, "", 0 );

                append( sb, "resourcesDirectory", 2 );
                append( sb, "The location of the directory (relative or absolute) containing non-jar resources that are to be included in the JNLP bundle.", 3 );
                append( sb, "", 0 );

                append( sb, "sign", 2 );
                append( sb, "The Sign Config", 3 );
                append( sb, "", 0 );

                append( sb, "templateDirectory (Default: ${project.basedir}/src/main/jnlp)", 2 );
                append( sb, "The location where the JNLP Velocity template files are stored.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "unsignAlreadySignedJars (Default: false)", 2 );
                append( sb, "Define whether to remove existing signatures.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Enable verbose output.", 3 );
                append( sb, "Expression: ${verbose}", 3 );
                append( sb, "", 0 );

                append( sb, "verifyjar (Default: true)", 2 );
                append( sb, "Indicates whether or not jar files should be verified after signing.", 3 );
                append( sb, "", 0 );

                append( sb, "workDirectory (Default: ${project.build.directory}/jnlp)", 2 );
                append( sb, "The directory in which files will be stored prior to processing.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "jnlp-inline".equals( goal ) )
        {
            append( sb, "webstart:jnlp-inline", 0 );
            append( sb, "Packages a jnlp application without launching a parallel lifecycle build.\nThe plugin tries to not re-sign\nre-pack if the dependent jar hasn\'t changed. As a consequence, if one modifies the pom jnlp config or a keystore, one should clean before rebuilding.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "attachArchive (Default: true)", 2 );
                append( sb, "Flag to attach the archive or not to the project\'s build.", 3 );
                append( sb, "", 0 );

                append( sb, "canUnsign (Default: true)", 2 );
                append( sb, "To authorize or not to unsign some already signed jar.\nIf set to false and the unsign parameter is set to true then the build will fail if there is a jar to unsign, to avoid this use then the extension jnlp component.\n", 3 );
                append( sb, "", 0 );

                append( sb, "codebase (Default: ${project.url}/jnlp)", 2 );
                append( sb, "The code base to use on the generated jnlp files.", 3 );
                append( sb, "Expression: ${jnlp.codebase}", 3 );
                append( sb, "", 0 );

                append( sb, "dependencies", 2 );
                append( sb, "[optional] transitive dependencies filter - if omitted, the plugin will include all transitive dependencies. Provided and test scope dependencies are always excluded.", 3 );
                append( sb, "", 0 );

                append( sb, "excludeTransitive", 2 );
                append( sb, "Set to true to exclude all transitive dependencies.", 3 );
                append( sb, "", 0 );

                append( sb, "gzip (Default: false)", 2 );
                append( sb, "Indicates whether or not gzip archives will be created for each of the jar files included in the webstart bundle.", 3 );
                append( sb, "", 0 );

                append( sb, "jnlp", 2 );
                append( sb, "The jnlp configuration element.", 3 );
                append( sb, "", 0 );

                append( sb, "jnlpExtensions", 2 );
                append( sb, "[optional] extensions configuration.", 3 );
                append( sb, "", 0 );

                append( sb, "keystore", 2 );
                append( sb, "A placeholder for an obsoleted configuration element.\nThis dummy parameter is here to force the plugin configuration to fail in case one didn\'t properly migrate from 1.0-alpha-1 to 1.0-alpha-2 configuration.\n\nIt will be removed before 1.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "libPath", 2 );
                append( sb, "The path where the libraries are placed within the jnlp structure.", 3 );
                append( sb, "", 0 );

                append( sb, "makeArchive (Default: true)", 2 );
                append( sb, "Flag to create the archive or not.", 3 );
                append( sb, "", 0 );

                append( sb, "outputJarVersions (Default: false)", 2 );
                append( sb, "When set to true, this flag indicates that a version attribute should be output in each of the jar resource elements in the generated JNLP file.", 3 );
                append( sb, "", 0 );

                append( sb, "pack200 (Default: false)", 2 );
                append( sb, "Indicates whether or not jar resources should be compressed using pack200. Setting this value to true requires SDK 5.0 or greater.", 3 );
                append( sb, "", 0 );

                append( sb, "resourcesDirectory", 2 );
                append( sb, "The location of the directory (relative or absolute) containing non-jar resources that are to be included in the JNLP bundle.", 3 );
                append( sb, "", 0 );

                append( sb, "sign", 2 );
                append( sb, "The Sign Config", 3 );
                append( sb, "", 0 );

                append( sb, "templateDirectory (Default: ${project.basedir}/src/main/jnlp)", 2 );
                append( sb, "The location where the JNLP Velocity template files are stored.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "unsignAlreadySignedJars (Default: false)", 2 );
                append( sb, "Define whether to remove existing signatures.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Enable verbose output.", 3 );
                append( sb, "Expression: ${verbose}", 3 );
                append( sb, "", 0 );

                append( sb, "verifyjar (Default: true)", 2 );
                append( sb, "Indicates whether or not jar files should be verified after signing.", 3 );
                append( sb, "", 0 );

                append( sb, "workDirectory (Default: ${project.build.directory}/jnlp)", 2 );
                append( sb, "The directory in which files will be stored prior to processing.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "jnlp-single".equals( goal ) )
        {
            append( sb, "webstart:jnlp-single", 0 );
            append( sb, "Packages a jnlp application without launching a parallel lifecycle build. Also, this mojo is not an aggregator, so it can be used multiple times in a single multimodule build.\nThe plugin tries to not re-sign\nre-pack if the dependent jar hasn\'t changed. As a consequence, if one modifies the pom jnlp config or a keystore, one should clean before rebuilding.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "attachArchive (Default: true)", 2 );
                append( sb, "Flag to attach the archive or not to the project\'s build.", 3 );
                append( sb, "", 0 );

                append( sb, "canUnsign (Default: true)", 2 );
                append( sb, "To authorize or not to unsign some already signed jar.\nIf set to false and the unsign parameter is set to true then the build will fail if there is a jar to unsign, to avoid this use then the extension jnlp component.\n", 3 );
                append( sb, "", 0 );

                append( sb, "codebase (Default: ${project.url}/jnlp)", 2 );
                append( sb, "The code base to use on the generated jnlp files.", 3 );
                append( sb, "Expression: ${jnlp.codebase}", 3 );
                append( sb, "", 0 );

                append( sb, "dependencies", 2 );
                append( sb, "[optional] transitive dependencies filter - if omitted, the plugin will include all transitive dependencies. Provided and test scope dependencies are always excluded.", 3 );
                append( sb, "", 0 );

                append( sb, "excludeTransitive", 2 );
                append( sb, "Set to true to exclude all transitive dependencies.", 3 );
                append( sb, "", 0 );

                append( sb, "gzip (Default: false)", 2 );
                append( sb, "Indicates whether or not gzip archives will be created for each of the jar files included in the webstart bundle.", 3 );
                append( sb, "", 0 );

                append( sb, "jnlp", 2 );
                append( sb, "The jnlp configuration element.", 3 );
                append( sb, "", 0 );

                append( sb, "jnlpExtensions", 2 );
                append( sb, "[optional] extensions configuration.", 3 );
                append( sb, "", 0 );

                append( sb, "keystore", 2 );
                append( sb, "A placeholder for an obsoleted configuration element.\nThis dummy parameter is here to force the plugin configuration to fail in case one didn\'t properly migrate from 1.0-alpha-1 to 1.0-alpha-2 configuration.\n\nIt will be removed before 1.0.\n", 3 );
                append( sb, "", 0 );

                append( sb, "libPath", 2 );
                append( sb, "The path where the libraries are placed within the jnlp structure.", 3 );
                append( sb, "", 0 );

                append( sb, "makeArchive (Default: true)", 2 );
                append( sb, "Flag to create the archive or not.", 3 );
                append( sb, "", 0 );

                append( sb, "outputJarVersions (Default: false)", 2 );
                append( sb, "When set to true, this flag indicates that a version attribute should be output in each of the jar resource elements in the generated JNLP file.", 3 );
                append( sb, "", 0 );

                append( sb, "pack200 (Default: false)", 2 );
                append( sb, "Indicates whether or not jar resources should be compressed using pack200. Setting this value to true requires SDK 5.0 or greater.", 3 );
                append( sb, "", 0 );

                append( sb, "resourcesDirectory", 2 );
                append( sb, "The location of the directory (relative or absolute) containing non-jar resources that are to be included in the JNLP bundle.", 3 );
                append( sb, "", 0 );

                append( sb, "sign", 2 );
                append( sb, "The Sign Config", 3 );
                append( sb, "", 0 );

                append( sb, "templateDirectory (Default: ${project.basedir}/src/main/jnlp)", 2 );
                append( sb, "The location where the JNLP Velocity template files are stored.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "unsignAlreadySignedJars (Default: false)", 2 );
                append( sb, "Define whether to remove existing signatures.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Enable verbose output.", 3 );
                append( sb, "Expression: ${verbose}", 3 );
                append( sb, "", 0 );

                append( sb, "verifyjar (Default: true)", 2 );
                append( sb, "Indicates whether or not jar files should be verified after signing.", 3 );
                append( sb, "", 0 );

                append( sb, "workDirectory (Default: ${project.build.directory}/jnlp)", 2 );
                append( sb, "The directory in which files will be stored prior to processing.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "report".equals( goal ) )
        {
            append( sb, "webstart:report", 0 );
            append( sb, "Creates a JNLP report.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "codebase (Default: ${project.url}/jnlp)", 2 );
                append( sb, "The code base to use on the generated jnlp files.", 3 );
                append( sb, "Expression: ${jnlp.codebase}", 3 );
                append( sb, "", 0 );

                append( sb, "jnlpSourceDirectory (Default: ${project.build.directory}/jnlp)", 2 );
                append( sb, "Directory where the jnlp artifacts and jnlp sources files reside.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2 );
                append( sb, "Location where the site is generated.", 3 );
                append( sb, "", 0 );

                append( sb, "outputName (Default: jnlp-report)", 2 );
                append( sb, "The default filename to use for the report.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${outputName}", 3 );
                append( sb, "", 0 );

                append( sb, "siteJnlpDirectory (Default: jnlp)", 2 );
                append( sb, "Directory in the site directory where the jnlp artifacts and jnlp sources files reside.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jnlp.siteJnlpDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "siteJnlpFile (Default: launch.jnlp)", 2 );
                append( sb, "Name of the main jnlp file of the project.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jnlp.siteJnlpFile}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "unsign".equals( goal ) )
        {
            append( sb, "webstart:unsign", 0 );
            append( sb, "Unsigns a JAR, removing signatures.\nThis code will hopefully be moved into the jar plugin when stable enough.\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "jarPath (Default: ${project.build.directory}/${project.build.finalName}.${project.packaging})", 2 );
                append( sb, "Path of the jar to unsign. When specified, the finalName is ignored.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Set this to true to disable signing. Useful to speed up build process in development environment.", 3 );
                append( sb, "Expression: ${maven.jar.unsign.skip}", 3 );
                append( sb, "", 0 );

                append( sb, "tempDirectory (Default: ${basedir})", 2 );
                append( sb, "The directory location used for temporary storage of files used by this mojo.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${tempdir}", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Enable verbose See options.", 3 );
                append( sb, "Expression: ${verbose}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
