package org.codehaus.mojo.webstart.util;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;

import java.util.ArrayList;
import java.util.List;


/**
 * An 'OR' artifact filter
 * <p/>
 * TODO this functionality must be available somewhere else
 *
 * @author jerome@coffeebreaks.org
 */
public class OrArtifactFilter
    implements ArtifactFilter
{
    private final List<ArtifactFilter> filters = new ArrayList<ArtifactFilter>();

    /**
     * {@inheritDoc}
     */
    public boolean include( Artifact artifact )
    {
        boolean include = false;
        for ( ArtifactFilter filter : this.filters )
        {
            if ( filter.include( artifact ) )
            {
                include = true;
                break;
            }
        }
        return include;
    }

    /**
     * Adds the artifact filter to be applied.
     *
     * @param artifactFilter new filter to add
     */
    public void add( ArtifactFilter artifactFilter )
    {
        this.filters.add( artifactFilter );
    }
}
