/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.generator;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.VelocityContext;
import org.codehaus.mojo.webstart.AbstractJnlpMojo;
import org.codehaus.mojo.webstart.JnlpExtension;
import org.codehaus.mojo.webstart.generator.AbstractGenerator;

public class Generator
extends AbstractGenerator {
    private AbstractJnlpMojo config;

    public Generator(MavenProject mavenProject, AbstractJnlpMojo task, String defaultTemplateResourceName, File resourceLoaderPath, File outputFile, String inputFileTemplatePath, String mainClass, String webstartJarURL, String encoding) {
        super(mavenProject, resourceLoaderPath, defaultTemplateResourceName, outputFile, inputFileTemplatePath, mainClass, webstartJarURL, encoding);
        this.config = task;
    }

    protected String getDependenciesText() {
        return this.indentText(4, Generator.getDependenciesText(this.config));
    }

    protected VelocityContext createAndPopulateContext() {
        VelocityContext context = super.createAndPopulateContext();
        if (this.config.hasJnlpExtensions()) {
            context.put("extensions", (Object)this.indentText(4, Generator.getExtensionsText(this.config)));
        }
        return context;
    }

    static String getDependenciesText(AbstractJnlpMojo config) {
        return Generator.getDependenciesText(config, config.getPackagedJnlpArtifacts());
    }

    static String getDependenciesText(AbstractJnlpMojo config, List artifacts) {
        String dependenciesText = "";
        if (artifacts.size() != 0) {
            StringBuffer buffer = new StringBuffer(100 * artifacts.size());
            buffer.append("\n");
            if (config.isPack200()) {
                buffer.append("<property name=\"jnlp.packEnabled\" value=\"true\" />\n");
            }
            String jarLibPath = null;
            if (config.getLibPath() != null) {
                jarLibPath = config.getLibPath();
                jarLibPath = jarLibPath != null && jarLibPath.trim().length() != 0 ? jarLibPath.trim() : null;
            }
            for (int i = 0; i < artifacts.size(); ++i) {
                Artifact artifact = (Artifact)artifacts.get(i);
                buffer.append("<jar href=\"");
                if (jarLibPath != null) {
                    buffer.append(jarLibPath).append("/");
                }
                buffer.append(artifact.getFile().getName()).append("\"");
                if (config.isOutputJarVersions()) {
                    buffer.append(" version=\"").append(artifact.getVersion()).append("\"");
                }
                if (config.isArtifactWithMainClass(artifact)) {
                    buffer.append(" main=\"true\"");
                }
                buffer.append("/>\n");
            }
            dependenciesText = buffer.toString();
        }
        return dependenciesText;
    }

    static String getExtensionsText(AbstractJnlpMojo config) {
        String text = "";
        List extensions = config.getJnlpExtensions();
        if (extensions != null && !extensions.isEmpty()) {
            StringBuffer buffer = new StringBuffer(100 * extensions.size());
            buffer.append("\n");
            Iterator it = extensions.iterator();
            while (it.hasNext()) {
                JnlpExtension extension = (JnlpExtension)it.next();
                buffer.append("<extension name=\"");
                buffer.append(extension.getName());
                buffer.append("\" href=\"");
                buffer.append(extension.getOutputFile());
                buffer.append("\"/>\n");
            }
            text = buffer.toString();
        }
        return text;
    }
}

