/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.weblogic.util;

import java.util.Iterator;
import java.util.Set;
import org.apache.maven.artifact.Artifact;

public class WeblogicMojoUtilities {
    private WeblogicMojoUtilities() {
    }

    public static String getAdminUrl(String inProtocol, String inServerName, String inServerPort) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(inProtocol).append("://");
        buffer.append(inServerName);
        buffer.append(":").append(inServerPort);
        return buffer.toString();
    }

    public static String updateArtifactName(String inName, String inProjectPackaging) {
        String newName = inName;
        if (inProjectPackaging.equalsIgnoreCase("ear")) {
            if (!inName.endsWith(".ear")) {
                newName = inName.concat(".ear");
            }
        } else if (inProjectPackaging.equalsIgnoreCase("war")) {
            if (!inName.endsWith(".war")) {
                newName = inName.concat(".war");
            }
        } else if (inProjectPackaging.equalsIgnoreCase("ejb")) {
            if (inName.endsWith(".ejb")) {
                newName = inName.replaceAll("\\.ejb", ".jar");
            } else if (!inName.endsWith(".jar")) {
                newName = inName.concat(".jar");
            }
        } else {
            throw new IllegalArgumentException("Unsupported project packaging " + inProjectPackaging);
        }
        return newName;
    }

    public static String getDependencies(Set inArtifacts) {
        if (inArtifacts == null || inArtifacts.isEmpty()) {
            return "";
        }
        Iterator iter = inArtifacts.iterator();
        StringBuffer buffer = new StringBuffer();
        if (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            buffer.append(artifact.getFile());
            while (iter.hasNext()) {
                artifact = (Artifact)iter.next();
                buffer.append(System.getProperty("path.separator"));
                buffer.append(artifact.getFile());
            }
        }
        return buffer.toString();
    }
}

