/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.weblogic;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.weblogic.util.WeblogicMojoUtilities;

public abstract class DeployMojoBase
extends AbstractMojo {
    private String adminServerHostName;
    private String adminServerProtocol;
    private String adminServerPort;
    private String userId;
    private String password;
    private String artifactPath;
    private String projectPackaging;
    private String name;
    private String targetNames;
    private boolean remote;

    public void execute() throws MojoExecutionException {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)"Running the Deploy Mojo Base without an implementation");
        }
        throw new MojoExecutionException("Unimplemented Mojo Base");
    }

    public String getAdminServerHostName() {
        return this.adminServerHostName;
    }

    public void setAdminServerHostName(String inAdminServerHostName) {
        this.adminServerHostName = inAdminServerHostName;
    }

    public String getAdminServerPort() {
        return this.adminServerPort;
    }

    public void setAdminServerPort(String inAdminServerPort) {
        this.adminServerPort = inAdminServerPort;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String inName) {
        this.name = inName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String inPassword) {
        this.password = inPassword;
    }

    public String getTargetNames() {
        return this.targetNames;
    }

    public void setTargetNames(String inTargetNames) {
        this.targetNames = inTargetNames;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String inUserId) {
        this.userId = inUserId;
    }

    public List getTargetList() {
        ArrayList<String> targets = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(this.getTargetNames(), ",");
        while (tokens.hasMoreTokens()) {
            targets.add(tokens.nextToken());
        }
        return targets;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean inRemote) {
        this.remote = inRemote;
    }

    public String getAdminServerProtocol() {
        return this.adminServerProtocol;
    }

    public void setAdminServerProtocol(String inAdminServerProtocol) {
        this.adminServerProtocol = inAdminServerProtocol;
    }

    protected String[] getInputParameters(String inOperation) {
        ArrayList<String> parameterList = new ArrayList<String>();
        String adminURL = WeblogicMojoUtilities.getAdminUrl(this.adminServerProtocol, this.adminServerHostName, this.adminServerPort);
        parameterList.add("-adminurl");
        parameterList.add(adminURL);
        parameterList.add("-username");
        parameterList.add(this.getUserId());
        parameterList.add("-password");
        parameterList.add(this.getPassword());
        if (!inOperation.equalsIgnoreCase("listapps")) {
            parameterList.add("-name");
            parameterList.add(this.getName());
        }
        if (!inOperation.equalsIgnoreCase("listapps")) {
            parameterList.add("-targets");
            parameterList.add(this.getTargetNames());
        }
        if (inOperation.equalsIgnoreCase("deploy")) {
            if (this.isRemote()) {
                parameterList.add("-upload");
            }
            parameterList.add("-source");
            parameterList.add(this.getArtifactPath());
        }
        String operation = "-" + inOperation;
        parameterList.add(operation);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().info((CharSequence)("Weblogic Deployment parameters " + parameterList));
        }
        return parameterList.toArray(new String[parameterList.size()]);
    }

    public String getArtifactPath() {
        String fixedArtifactPath = WeblogicMojoUtilities.updateArtifactName(this.artifactPath, this.projectPackaging);
        return fixedArtifactPath;
    }

    public void setArtifactPath(String inArtifactPath) {
        this.artifactPath = inArtifactPath;
    }

    public String getProjectPackaging() {
        return this.projectPackaging;
    }

    public void setProjectPackaging(String inProjectPackaging) {
        this.projectPackaging = inProjectPackaging;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DeployMojoBase[");
        buffer.append("adminServerHostName = ").append(this.adminServerHostName);
        buffer.append(", adminServerProtocol = ").append(this.adminServerProtocol);
        buffer.append(", adminServerPort = ").append(this.adminServerPort);
        buffer.append(", userId = ").append(this.userId);
        buffer.append(", password = ").append(this.password);
        buffer.append(", artifactPath = ").append(this.artifactPath);
        buffer.append(", projectPackaging = ").append(this.projectPackaging);
        buffer.append(", name = ").append(this.name);
        buffer.append(", targetNames = ").append(this.targetNames);
        buffer.append(", remote = ").append(this.remote);
        buffer.append("]");
        return buffer.toString();
    }
}

