package org.codehaus.mojo.weblogic;

/*
 * Copyright 2006 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.apache.maven.plugin.MojoExecutionException;

import weblogic.Deployer;

/**
 * Stop an artifact on Weblogic server(s) or cluster(s).
 * 
 * @author <a href="mailto:scott@theryansplace.com">Scott Ryan</a>
 * @version $Id: StopMojo.java 2848 2006-12-21 19:49:14Z scryan $
 * @description This mojo will stop a component (EAR, WAR) on a server or group of servers.
 * @goal stop
 */
public class StopMojo extends DeployMojoBase
{

    /**
     * This method will perform the stop of an application unit.
     * 
     * @throws MojoExecutionException
     *             Thrown if we fail to obtain a Weblogic deployment instance.
     * 
     */
    public void execute() throws MojoExecutionException
    {

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( "Weblogic artifact stop beginning with parameters " + this.toString() );
        }

        // get the basic parameters
        String[] parameters = this.getInputParameters( "stop" );

        try
        {

            // Deploy with the parameters
            Deployer deployer = new Deployer( parameters );
            deployer.run();
        }
        catch ( Exception ex )
        {
            getLog().error( "Exception encountered during artifact stop ", ex );
            throw new MojoExecutionException( "Exception encountered during artifact stop", ex );
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( "Weblogic artifact stop successful " );
        }

    }

}
