/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.was6;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.was6.AbstractAppMojo;
import org.codehaus.mojo.was6.Role;
import org.codehaus.plexus.util.StringUtils;
import org.dom4j.Document;

public class WsInstallAppMojo
extends AbstractAppMojo {
    private boolean deployWebServices;
    private boolean updateExisting;
    private String targetCluster;
    private String cluster;
    private String targetCell;
    private String cell;
    private String targetNode;
    private String node;
    private String targetServer;
    private String server;
    private File earFile;
    private String mapModulesToServers;
    private List roles;
    private String mapWebModToVH;
    private String contextRoot;

    protected String getTaskName() {
        return "wsInstallApp";
    }

    protected void configureBuildScript(Document document) throws MojoExecutionException {
        String serverToUse;
        String nodeToUse;
        String cellToUse;
        String clusterToUse;
        super.configureBuildScript(document);
        if (this.earFile == null) {
            throw new MojoExecutionException("Earfile not specified");
        }
        if (!this.earFile.canRead()) {
            throw new MojoExecutionException("Bad archive: " + this.earFile.getAbsolutePath());
        }
        this.configureTaskAttribute(document, "ear", this.earFile.getAbsolutePath());
        StringBuffer options = new StringBuffer();
        options.append("-appname ").append(this.applicationName);
        if (this.contextRoot != null) {
            options.append(" -contextroot ").append(this.contextRoot);
        }
        if (this.mapWebModToVH != null) {
            options.append(" -MapWebModToVH ").append(this.mapWebModToVH);
        }
        if (this.updateExisting) {
            options.append(" -update");
        }
        String string = clusterToUse = this.targetCluster != null ? this.cluster : null;
        if (StringUtils.isNotEmpty((String)clusterToUse)) {
            options.append(" -cluster ").append(clusterToUse);
        }
        String string2 = cellToUse = this.targetCell != null ? this.cell : null;
        if (StringUtils.isNotEmpty((String)cellToUse)) {
            options.append(" -cell ").append(cellToUse);
        }
        String string3 = nodeToUse = this.targetNode != null ? this.node : null;
        if (StringUtils.isNotEmpty((String)nodeToUse)) {
            options.append(" -node ").append(nodeToUse);
        }
        String string4 = serverToUse = this.targetServer != null ? this.server : null;
        if (StringUtils.isNotEmpty((String)serverToUse)) {
            options.append(" -server ").append(serverToUse);
        }
        if (this.mapModulesToServers != null) {
            options.append(" -MapModulesToServers ").append(this.mapModulesToServers);
        }
        if (CollectionUtils.isNotEmpty((Collection)this.roles)) {
            options.append(" -MapRolesToUsers { ");
            Iterator iterator = this.roles.iterator();
            while (iterator.hasNext()) {
                Role role = (Role)iterator.next();
                options.append(role.getRoleMapping());
            }
            options.append(" } ");
        }
        if (this.deployWebServices) {
            options.append(" -deployws ");
        }
        this.configureTaskAttribute(document, "options", options);
    }
}

