/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.was6;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public abstract class AbstractWas6Mojo
extends AbstractMojo {
    private File wasHome;
    private File workingDirectory;
    private boolean verbose;
    private boolean failOnError;
    private MavenProject mavenProject;
    private Settings settings;
    private File logFile;

    protected File getWorkingDirectory() {
        return this.workingDirectory;
    }

    protected boolean isVerbose() {
        return this.verbose;
    }

    protected Settings getSettings() {
        return this.settings;
    }

    protected MavenProject getMavenProject() {
        return this.mavenProject;
    }

    protected File getWasHome() {
        return this.wasHome;
    }

    protected File getWsAntExecutable() throws MojoExecutionException {
        File executableFile = new File(this.wasHome, "bin/ws_ant." + (SystemUtils.IS_OS_UNIX ? "sh" : "bat"));
        if (!executableFile.isFile()) {
            throw new MojoExecutionException(executableFile.getAbsolutePath() + " does not exist or is not a file");
        }
        return executableFile;
    }

    private File getBuildScript() throws MojoExecutionException {
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/build.xml");
            String scriptSource = IOUtils.toString((InputStream)inputStream);
            Document buildScriptDocument = DocumentHelper.parseText((String)scriptSource);
            this.configureTaskAttribute(buildScriptDocument, "wasHome", this.wasHome);
            this.configureTaskAttribute(buildScriptDocument, "failonerror", Boolean.toString(this.failOnError));
            Element projectElement = buildScriptDocument.getRootElement();
            projectElement.addAttribute("default", this.getTaskName());
            this.configureBuildScript(buildScriptDocument);
            this.getWorkingDirectory().mkdir();
            File buildScriptFile = new File(this.getWorkingDirectory(), "was6plugin-build.xml");
            FileWriter writer = new FileWriter(buildScriptFile);
            XMLWriter xmlWriter = new XMLWriter((Writer)writer, OutputFormat.createPrettyPrint());
            xmlWriter.write(buildScriptDocument);
            xmlWriter.flush();
            xmlWriter.close();
            return buildScriptFile;
        }
        catch (DocumentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    protected void configureTaskAttribute(Document document, String attributeName, Object value) throws MojoExecutionException {
        Element taskElement = (Element)document.selectSingleNode("//target[@name='" + this.getTaskName() + "']/" + this.getTaskName());
        if (taskElement == null) {
            throw new MojoExecutionException("BUG: Task is not defined: " + this.getTaskName());
        }
        Attribute attribute = (Attribute)taskElement.selectSingleNode("@" + attributeName);
        if (attribute == null) {
            this.getLog().warn((CharSequence)("Build script does not contain attribute: " + attributeName));
            return;
        }
        if (value != null) {
            String valueToSet = value instanceof File ? ((File)value).getAbsolutePath() : value.toString();
            attribute.setText(valueToSet);
        } else {
            taskElement.remove(attribute);
        }
    }

    protected abstract void configureBuildScript(Document var1) throws MojoExecutionException;

    private Commandline getCommandline() throws MojoExecutionException {
        File buildScript = this.getBuildScript();
        Commandline commandLine = new Commandline();
        commandLine.setExecutable(this.getWsAntExecutable().getAbsolutePath());
        commandLine.setWorkingDirectory(this.mavenProject.getBuild().getDirectory());
        commandLine.createArg().setLine("-buildfile " + buildScript.getAbsolutePath());
        if (!this.getSettings().isInteractiveMode()) {
            commandLine.createArg().setValue("-noinput");
        }
        if (this.logFile != null) {
            commandLine.createArg().setLine("-logfile " + this.logFile.getAbsolutePath());
        }
        if (this.isVerbose()) {
            commandLine.createArg().setValue("-verbose");
            commandLine.createArg().setValue("-debug");
        }
        commandLine.createArg().setValue(this.getTaskName());
        return commandLine;
    }

    protected abstract String getTaskName();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.wasHome == null) {
            throw new MojoExecutionException("wasHome not defined");
        }
        if (!this.wasHome.exists() && !this.wasHome.isDirectory()) {
            throw new MojoExecutionException(this.wasHome.getAbsolutePath() + " does not exist or is not a directory");
        }
        Commandline commandLine = this.getCommandline();
        this.executeCmdLine(commandLine);
    }

    private void executeCmdLine(Commandline commandline) throws MojoFailureException {
        try {
            StreamConsumer errConsumer = this.getStreamConsumer("error");
            StreamConsumer infoConsumer = this.getStreamConsumer("info");
            this.getLog().debug((CharSequence)("Executing command line: " + StringUtils.join((Object[])commandline.getShellCommandline(), (String)" ")));
            int returncode = CommandLineUtils.executeCommandLine((Commandline)commandline, (StreamConsumer)infoConsumer, (StreamConsumer)errConsumer);
            String logmsg = "Return code: " + returncode;
            if (returncode != 0) {
                throw new MojoFailureException(logmsg);
            }
            this.getLog().info((CharSequence)logmsg);
        }
        catch (CommandLineException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }

    private StreamConsumer getStreamConsumer(final String level) {
        StreamConsumer consumer = new StreamConsumer(){

            public void consumeLine(String line) {
                if (level.equalsIgnoreCase("info")) {
                    AbstractWas6Mojo.this.getLog().info((CharSequence)line);
                } else {
                    AbstractWas6Mojo.this.getLog().error((CharSequence)line);
                }
            }
        };
        return consumer;
    }
}

