/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.xml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.model.Dependency;
import org.codehaus.mojo.versions.api.AbstractVersionDetails;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.ArtifactVersionsCache;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.reporting.OverviewStats;
import org.codehaus.mojo.versions.reporting.model.DependencyInfo;
import org.codehaus.mojo.versions.reporting.model.DependencyReportSummary;
import org.codehaus.mojo.versions.reporting.model.DependencyUpdatesModel;
import org.codehaus.mojo.versions.reporting.model.DependencyUpdatesReport;
import org.codehaus.mojo.versions.reporting.model.io.stax.DependencyUpdatesReportStaxWriter;
import org.codehaus.mojo.versions.reporting.util.ReportRenderer;
import org.codehaus.mojo.versions.xml.CommonXmlReportRendererUtils;

public class DependencyUpdatesXmlReportRenderer
implements ReportRenderer {
    private final DependencyUpdatesModel model;
    private final Path outputFile;
    private final ArtifactVersionsCache newestUpdateCache = new ArtifactVersionsCache(AbstractVersionDetails::getNewestUpdateWithinSegment);
    private final boolean allowSnapshots;

    public DependencyUpdatesXmlReportRenderer(DependencyUpdatesModel model, Path outputFile, boolean allowSnapshots) {
        this.model = model;
        this.outputFile = outputFile;
        this.allowSnapshots = allowSnapshots;
    }

    @Override
    public boolean isAllowSnapshots() {
        return this.allowSnapshots;
    }

    public String getTitle() {
        return "Dependency updates";
    }

    public void render() {
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            new DependencyUpdatesReportStaxWriter().write((Writer)writer, new DependencyUpdatesReport(){
                {
                    this.setSummary(new DependencyReportSummary(){
                        {
                            Object overviewStats = OverviewStats.fromUpdates(DependencyUpdatesXmlReportRenderer.this.model.getAllUpdates().values(), DependencyUpdatesXmlReportRenderer.this.newestUpdateCache, DependencyUpdatesXmlReportRenderer.this.isAllowSnapshots());
                            this.setUsingLastVersion(String.valueOf(((OverviewStats)overviewStats).getUpToDate()));
                            this.setNextVersionAvailable(String.valueOf(((OverviewStats)overviewStats).getAny()));
                            this.setNextIncrementalAvailable(String.valueOf(((OverviewStats)overviewStats).getIncremental()));
                            this.setNextMinorAvailable(String.valueOf(((OverviewStats)overviewStats).getMinor()));
                            this.setNextMajorAvailable(String.valueOf(((OverviewStats)overviewStats).getMajor()));
                        }
                    });
                    this.setDependencyManagements(DependencyUpdatesXmlReportRenderer.createDependencyInfo(DependencyUpdatesXmlReportRenderer.this.model.getArtifactManagementUpdates(), DependencyUpdatesXmlReportRenderer.this.isAllowSnapshots()));
                    this.setDependencies(DependencyUpdatesXmlReportRenderer.createDependencyInfo(DependencyUpdatesXmlReportRenderer.this.model.getArtifactUpdates(), DependencyUpdatesXmlReportRenderer.this.isAllowSnapshots()));
                }
            });
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<DependencyInfo> createDependencyInfo(Map<Dependency, ArtifactVersions> versions, boolean allowSnapshots) {
        return versions.entrySet().stream().map(e -> new DependencyInfo((Map.Entry)e, allowSnapshots){
            final /* synthetic */ Map.Entry val$e;
            final /* synthetic */ boolean val$allowSnapshots;
            {
                this.val$e = entry;
                this.val$allowSnapshots = bl;
                this.setGroupId(((Dependency)this.val$e.getKey()).getGroupId());
                this.setArtifactId(((Dependency)this.val$e.getKey()).getArtifactId());
                this.setCurrentVersion(((Dependency)this.val$e.getKey()).getVersion());
                this.setScope(((Dependency)this.val$e.getKey()).getScope());
                this.setType(((Dependency)this.val$e.getKey()).getType());
                this.setClassifier(((Dependency)this.val$e.getKey()).getClassifier());
                Optional.ofNullable(((ArtifactVersions)this.val$e.getValue()).getNewestUpdateWithinSegment(Optional.empty(), this.val$allowSnapshots)).map(ArtifactVersion::toString).ifPresent(arg_0 -> (this).setLastVersion(arg_0));
                CommonXmlReportRendererUtils.setSection((AbstractVersionDetails)this.val$e.getValue(), Segment.INCREMENTAL, arg_0 -> (this).setIncrementals(arg_0), this.val$allowSnapshots);
                CommonXmlReportRendererUtils.setSection((AbstractVersionDetails)this.val$e.getValue(), Segment.MINOR, arg_0 -> (this).setMinors(arg_0), this.val$allowSnapshots);
                CommonXmlReportRendererUtils.setSection((AbstractVersionDetails)this.val$e.getValue(), Segment.MAJOR, arg_0 -> (this).setMajors(arg_0), this.val$allowSnapshots);
                this.setStatus(CommonXmlReportRendererUtils.statusFor(this.getLastVersion(), this.getIncrementals(), this.getMinors()));
            }
        }).collect(Collectors.toList());
    }
}

