/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;

public class ArtifactVersions {
    private final Artifact artifact;
    private final SortedSet versions;
    private final Comparator rule;

    public ArtifactVersions(Artifact artifact, ArtifactVersion[] versions, Comparator rule) {
        this(artifact, Arrays.asList(versions), rule);
    }

    public ArtifactVersions(Artifact artifact, List versions, Comparator rule) {
        this.artifact = artifact;
        this.rule = rule;
        this.versions = new TreeSet(rule);
        this.versions.addAll(versions);
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public String getGroupId() {
        return this.getArtifact().getGroupId();
    }

    public String getArtifactId() {
        return this.getArtifact().getArtifactId();
    }

    public ArtifactVersion[] getVersions() {
        return this.getVersions(true);
    }

    public ArtifactVersion[] getVersions(boolean includeSnapshots) {
        TreeSet<ArtifactVersion> result;
        if (includeSnapshots) {
            result = this.versions;
        } else {
            result = new TreeSet<ArtifactVersion>(this.rule);
            Iterator i = this.versions.iterator();
            while (i.hasNext()) {
                ArtifactVersion candidate = (ArtifactVersion)i.next();
                if (ArtifactUtils.isSnapshot((String)candidate.toString())) continue;
                result.add(candidate);
            }
        }
        return result.toArray(new ArtifactVersion[result.size()]);
    }

    public ArtifactVersion[] getVersions(VersionRange versionRange, boolean includeSnapshots) {
        TreeSet<ArtifactVersion> result = new TreeSet<ArtifactVersion>(this.rule);
        Iterator i = this.versions.iterator();
        while (i.hasNext()) {
            ArtifactVersion candidate = (ArtifactVersion)i.next();
            if (!versionRange.containsVersion(candidate) || !includeSnapshots && ArtifactUtils.isSnapshot((String)candidate.toString())) continue;
            result.add(candidate);
        }
        return result.toArray(new ArtifactVersion[result.size()]);
    }

    public ArtifactVersion[] getNewerVersions(ArtifactVersion version) {
        return this.getNewerVersions(version, true);
    }

    public ArtifactVersion[] getNewerVersions(ArtifactVersion version, boolean includeSnapshots) {
        TreeSet<ArtifactVersion> result = new TreeSet<ArtifactVersion>(this.rule);
        Iterator i = this.versions.tailSet(version).iterator();
        while (i.hasNext()) {
            ArtifactVersion candidate = (ArtifactVersion)i.next();
            if (this.rule.compare(version, candidate) >= 0 || !includeSnapshots && ArtifactUtils.isSnapshot((String)candidate.toString())) continue;
            result.add(candidate);
        }
        return result.toArray(new ArtifactVersion[result.size()]);
    }

    public ArtifactVersion getLatestVersion(ArtifactVersion currentVersion, ArtifactVersion upperBound) {
        return this.getLatestVersion(currentVersion, upperBound, true);
    }

    public ArtifactVersion getLatestVersion(ArtifactVersion currentVersion, ArtifactVersion upperBound, boolean includeSnapshots) {
        try {
            String versionRangeStr = "(" + currentVersion.toString() + "," + upperBound.toString() + ")";
            return this.getLatestVersion(VersionRange.createFromVersionSpec((String)versionRangeStr), includeSnapshots);
        }
        catch (InvalidVersionSpecificationException e) {
            return null;
        }
    }

    public ArtifactVersion getLatestVersion(VersionRange versionRange, boolean includeSnapshots) {
        ArtifactVersion latest = null;
        Iterator i = this.versions.iterator();
        while (i.hasNext()) {
            ArtifactVersion candidate = (ArtifactVersion)i.next();
            if (!versionRange.containsVersion(candidate) || !includeSnapshots && ArtifactUtils.isSnapshot((String)candidate.toString())) continue;
            if (latest == null) {
                latest = candidate;
                continue;
            }
            if (this.rule.compare(latest, candidate) >= 0) continue;
            latest = candidate;
        }
        return latest;
    }

    public boolean containsVersion(String version) {
        Iterator i = this.versions.iterator();
        while (i.hasNext()) {
            ArtifactVersion candidate = (ArtifactVersion)i.next();
            if (!version.equals(candidate.toString())) continue;
            return true;
        }
        return false;
    }

    public ArtifactVersion[] getNewerVersions(String version) {
        return this.getNewerVersions(version, true);
    }

    public ArtifactVersion[] getNewerVersions(String version, boolean includeSnapshots) {
        return this.getNewerVersions((ArtifactVersion)new DefaultArtifactVersion(version), includeSnapshots);
    }
}

