/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

public class DisplayDependencyUpdatesMojo
extends AbstractVersionsUpdaterMojo {
    private static final int INFO_PAD_SIZE = 68;

    public void execute() throws MojoExecutionException, MojoFailureException {
        TreeSet dependencies = new TreeSet(new DependencyComparator());
        dependencies.addAll(this.getProject().getDependencies());
        ArrayList<String> updates = new ArrayList<String>();
        Iterator i = dependencies.iterator();
        while (i.hasNext()) {
            Dependency dependency = (Dependency)i.next();
            String groupId = dependency.getGroupId();
            String artifactId = dependency.getArtifactId();
            String version = dependency.getVersion();
            this.getLog().debug((CharSequence)("Checking " + groupId + ":" + artifactId + " for updates newer than " + version));
            VersionRange versionRange = null;
            try {
                versionRange = VersionRange.createFromVersionSpec((String)version);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoExecutionException("Invalid version range specification: " + version, (Exception)((Object)e));
            }
            Artifact artifact = this.artifactFactory.createDependencyArtifact(groupId, artifactId, versionRange, dependency.getType(), dependency.getClassifier(), dependency.getScope());
            ArtifactVersion artifactVersion = this.findLatestVersion(artifact, versionRange, null, false);
            DefaultArtifactVersion currentVersion = new DefaultArtifactVersion(version);
            if (artifactVersion == null || this.getHelper().getVersionComparator(artifact).compare(currentVersion, artifactVersion) >= 0) continue;
            String newVersion = artifactVersion.toString();
            StringBuffer buf = new StringBuffer();
            buf.append(groupId).append(':');
            buf.append(artifactId);
            buf.append(' ');
            int padding = 68 - version.length() - newVersion.length() - 4;
            while (buf.length() < padding) {
                buf.append('.');
            }
            buf.append(' ');
            buf.append(version);
            buf.append(" -> ");
            buf.append(newVersion);
            updates.add(buf.toString());
        }
        this.getLog().info((CharSequence)"");
        if (updates.isEmpty()) {
            this.getLog().info((CharSequence)"All dependencies are using the latest versions.");
        } else {
            this.getLog().info((CharSequence)"The following dependency updates are available:");
            i = updates.iterator();
            while (i.hasNext()) {
                this.getLog().info((CharSequence)("  " + i.next()));
            }
        }
        this.getLog().info((CharSequence)"");
    }

    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
    }

    private static class DependencyComparator
    implements Comparator {
        private DependencyComparator() {
        }

        public int compare(Object o1, Object o2) {
            Dependency d1 = (Dependency)o1;
            Dependency d2 = (Dependency)o2;
            int r = d1.getGroupId().compareTo(d2.getGroupId());
            if (r == 0) {
                r = d1.getArtifactId().compareTo(d2.getArtifactId());
            }
            if (r == 0) {
                String v1 = d1.getVersion();
                String v2 = d2.getVersion();
                if (v1 == null) {
                    return v2 == null ? 0 : -1;
                }
                if (v2 == null) {
                    return 1;
                }
                r = v1.compareTo(v2);
            }
            return r;
        }
    }
}

