/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.truezip.util;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsSyncException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.truezip.util.TrueZip;
import org.codehaus.mojo.truezip.util.TrueZipFileSet;
import org.codehaus.mojo.truezip.util.TrueZipFileSetManager;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class DefaultTrueZip
implements TrueZip {
    public void sync() throws FsSyncException {
        TFile.umount();
    }

    public List list(TrueZipFileSet fileSet, boolean verbose, Log logger) {
        TrueZipFileSetManager fileSetManager = new TrueZipFileSetManager(logger, verbose);
        return this.list(fileSet, fileSetManager);
    }

    public List list(TrueZipFileSet fileSet) {
        TrueZipFileSetManager fileSetManager = new TrueZipFileSetManager();
        return this.list(fileSet, fileSetManager);
    }

    private List list(TrueZipFileSet fileSet, TrueZipFileSetManager fileSetManager) {
        if (StringUtils.isBlank((String)fileSet.getDirectory())) {
            fileSet.setDirectory(".");
        }
        String[] files = fileSetManager.getIncludedFiles(fileSet);
        ArrayList<TFile> fileLists = new ArrayList<TFile>();
        for (int i = 0; i < files.length; ++i) {
            TFile source = new TFile(fileSet.getDirectory(), files[i]);
            fileLists.add(source);
        }
        return fileLists;
    }

    public void move(TrueZipFileSet fileSet, boolean verbose, Log logger) throws IOException {
        TrueZipFileSetManager fileSetManager = new TrueZipFileSetManager(logger, verbose);
        this.move(fileSet, fileSetManager);
    }

    public void move(TrueZipFileSet fileSet) throws IOException {
        TrueZipFileSetManager fileSetManager = new TrueZipFileSetManager();
        this.move(fileSet, fileSetManager);
    }

    public void copy(TrueZipFileSet fileSet, boolean verbose, Log logger) throws IOException {
        TrueZipFileSetManager fileSetManager = new TrueZipFileSetManager(logger, verbose);
        this.copy(fileSet, fileSetManager);
    }

    public void copy(TrueZipFileSet fileSet) throws IOException {
        TrueZipFileSetManager fileSetManager = new TrueZipFileSetManager();
        this.copy(fileSet, fileSetManager);
    }

    public void copy(TrueZipFileSet oneFileSet, TrueZipFileSetManager fileSetManager) throws IOException {
        if (StringUtils.isBlank((String)oneFileSet.getDirectory())) {
            oneFileSet.setDirectory(".");
        }
        String[] files = fileSetManager.getIncludedFiles(oneFileSet);
        for (int i = 0; i < files.length; ++i) {
            String relativeDestPath = files[i];
            if (!StringUtils.isBlank((String)oneFileSet.getOutputDirectory())) {
                relativeDestPath = oneFileSet.getOutputDirectory() + "/" + relativeDestPath;
            }
            TFile dest = new TFile(relativeDestPath);
            TFile source = new TFile(oneFileSet.getDirectory(), files[i]);
            this.copyFile(source, dest);
        }
    }

    public void copyFile(TFile source, TFile dest) throws IOException {
        TFile destParent = dest.getParentFile();
        if (!destParent.isDirectory() && !destParent.mkdirs()) {
            throw new IOException("Unable to create " + destParent);
        }
        if (source.isArchive()) {
            if (dest.isArchive() && FileUtils.getExtension((String)dest.getPath()).equals(FileUtils.getExtension((String)source.getPath()))) {
                TFile.umount();
                TFile.cp_rp((File)source, (File)dest, (TArchiveDetector)TArchiveDetector.NULL, (TArchiveDetector)TArchiveDetector.NULL);
            } else {
                source.cp_rp((File)dest);
            }
        } else if (source.isDirectory()) {
            source.cp_rp((File)dest);
        } else {
            TFile.cp_p((File)source, (File)dest);
        }
    }

    public void moveFile(TFile source, TFile dest) throws IOException {
        TFile file = new TFile((File)source);
        TFile tofile = new TFile((File)dest);
        file.mv((File)tofile);
    }

    public void remove(TrueZipFileSet fileSet, boolean verbose, Log logger) throws IOException {
        TrueZipFileSetManager fileSetManager = new TrueZipFileSetManager(logger, verbose);
        this.remove(fileSet, fileSetManager);
    }

    public void remove(TrueZipFileSet fileSet) throws IOException {
        TrueZipFileSetManager fileSetManager = new TrueZipFileSetManager();
        this.remove(fileSet, fileSetManager);
    }

    private void remove(TrueZipFileSet oneFileSet, TrueZipFileSetManager fileSetManager) throws IOException {
        if (StringUtils.isBlank((String)oneFileSet.getDirectory())) {
            throw new IOException("FileSet's directory is required.");
        }
        TFile directory = new TFile(oneFileSet.getDirectory());
        if (!directory.isDirectory()) {
            throw new IOException("FileSet's directory: " + directory + " not found.");
        }
        fileSetManager.delete(oneFileSet, true);
    }

    private void move(TrueZipFileSet fileSet, TrueZipFileSetManager fileSetManager) throws IOException {
        this.copy(fileSet, fileSetManager);
        this.remove(fileSet, fileSetManager);
    }
}

