package org.codehaus.mojo.truezip;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on truezip-maven-plugin. Call <pre>  mvn truezip:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Sat Feb 14 19:40:36 PST 2009
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo:truezip-maven-plugin:1.0-beta-2", 0 );
        append( sb, "", 0 );

        append( sb, "Maven Plugin for TrueZIP 1.0-beta-2", 0 );
        append( sb, "Use this plugin create new or manipulate existing archives", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 6 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "copy".equals( goal ) )
        {
            append( sb, "truezip:copy", 0 );
            append( sb, "Copy a set of files in and out of an existing archive", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "files", 2 );
                append( sb, "The list of FileItem to to manipulate the archive. Use this configuration when you have a need to do copying with option to change file name.", 3 );
                append( sb, "", 0 );

                append( sb, "fileset", 2 );
                append( sb, "A single FileSet to manipulate the archive.", 3 );
                append( sb, "", 0 );

                append( sb, "filesets", 2 );
                append( sb, "The list of FileSet to manipulate the archive.", 3 );
                append( sb, "", 0 );

                append( sb, "immediateUpdate (Default: true)", 2 );
                append( sb, "Enable automatic file update after each MOJO execution. If set to false, immediate update is not performed. Then, the updated files are flushed at undefined time (when the VM finalizes objects). Otherwise, a forced file update can be triggered by using update goal in an separate execution.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Enable verbose mode", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "truezip:help", 0 );
            append( sb, "Display help information on truezip-maven-plugin. Call\n\u00a0\u00a0mvn\u00a0truezip:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "list".equals( goal ) )
        {
            append( sb, "truezip:list", 0 );
            append( sb, "List all files in the archive.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "fileset", 2 );
                append( sb, "A single FileSet to manipulate the archive.", 3 );
                append( sb, "", 0 );

                append( sb, "filesets", 2 );
                append( sb, "The list of FileSet to manipulate the archive.", 3 );
                append( sb, "", 0 );

                append( sb, "immediateUpdate (Default: true)", 2 );
                append( sb, "Enable automatic file update after each MOJO execution. If set to false, immediate update is not performed. Then, the updated files are flushed at undefined time (when the VM finalizes objects). Otherwise, a forced file update can be triggered by using update goal in an separate execution.", 3 );
                append( sb, "", 0 );

                append( sb, "outputFile", 2 );
                append( sb, "Write list output to a file if needed", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Enable verbose mode", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "move".equals( goal ) )
        {
            append( sb, "truezip:move", 0 );
            append( sb, "Rename a file in archive.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "from", 2 );
                append( sb, "Path of original file", 3 );
                append( sb, "", 0 );

                append( sb, "immediateUpdate (Default: true)", 2 );
                append( sb, "Enable automatic file update after each MOJO execution. If set to false, immediate update is not performed. Then, the updated files are flushed at undefined time (when the VM finalizes objects). Otherwise, a forced file update can be triggered by using update goal in an separate execution.", 3 );
                append( sb, "", 0 );

                append( sb, "to", 2 );
                append( sb, "Path of destination file", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "remove".equals( goal ) )
        {
            append( sb, "truezip:remove", 0 );
            append( sb, "Remove a set of files from an existing archive", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "fileset", 2 );
                append( sb, "A single FileSet to manipulate the archive.", 3 );
                append( sb, "", 0 );

                append( sb, "filesets", 2 );
                append( sb, "The list of FileSet to manipulate the archive.", 3 );
                append( sb, "", 0 );

                append( sb, "immediateUpdate (Default: true)", 2 );
                append( sb, "Enable automatic file update after each MOJO execution. If set to false, immediate update is not performed. Then, the updated files are flushed at undefined time (when the VM finalizes objects). Otherwise, a forced file update can be triggered by using update goal in an separate execution.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Enable verbose mode", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "update".equals( goal ) )
        {
            append( sb, "truezip:update", 0 );
            append( sb, "Update open archives immediately, flush cached data to disk.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "immediateUpdate (Default: true)", 2 );
                append( sb, "Enable automatic file update after each MOJO execution. If set to false, immediate update is not performed. Then, the updated files are flushed at undefined time (when the VM finalizes objects). Otherwise, a forced file update can be triggered by using update goal in an separate execution.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     */
    private List toLines( String text, int indent )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i] );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     */
    private void toLines( List lines, String line )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
