/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.truezip.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.model.fileset.FileSet;
import org.codehaus.mojo.truezip.Fileset;
import org.codehaus.mojo.truezip.util.TrueZip;
import org.codehaus.mojo.truezip.util.TrueZipFileSetManager;
import org.codehaus.plexus.util.StringUtils;

public class DefaultTrueZip
implements TrueZip {
    public List list(FileSet fileSet, boolean verbose, Log logger) {
        if (StringUtils.isBlank((String)fileSet.getDirectory())) {
            fileSet.setDirectory(".");
        }
        logger.info((CharSequence)("List " + fileSet));
        TrueZipFileSetManager fileSetManager = new TrueZipFileSetManager(logger, verbose);
        String[] files = fileSetManager.getIncludedFiles(fileSet);
        ArrayList<de.schlichtherle.io.File> fileLists = new ArrayList<de.schlichtherle.io.File>();
        for (int i = 0; i < files.length; ++i) {
            de.schlichtherle.io.File source = new de.schlichtherle.io.File(fileSet.getDirectory(), files[i]);
            fileLists.add(source);
        }
        return fileLists;
    }

    public void copy(FileSet oneFileSet, boolean verbose, Log logger) throws IOException {
        if (StringUtils.isBlank((String)oneFileSet.getDirectory())) {
            oneFileSet.setDirectory(".");
        }
        TrueZipFileSetManager fileSetManager = new TrueZipFileSetManager(logger, verbose);
        String[] files = fileSetManager.getIncludedFiles(oneFileSet);
        for (int i = 0; i < files.length; ++i) {
            String relativeDestPath = files[i];
            if (!StringUtils.isBlank((String)oneFileSet.getOutputDirectory())) {
                relativeDestPath = oneFileSet.getOutputDirectory() + "/" + relativeDestPath;
            }
            de.schlichtherle.io.File dest = new de.schlichtherle.io.File(relativeDestPath);
            de.schlichtherle.io.File source = new de.schlichtherle.io.File(oneFileSet.getDirectory(), files[i]);
            this.copyFile(source, dest);
        }
    }

    public void copyFile(de.schlichtherle.io.File source, de.schlichtherle.io.File dest) throws IOException {
        de.schlichtherle.io.File destParent = (de.schlichtherle.io.File)dest.getParentFile();
        if (!destParent.isDirectory() && !destParent.mkdirs()) {
            throw new IOException("Unable to create " + destParent);
        }
        if (source.isArchive()) {
            File realSource = new File(source.getAbsolutePath());
            de.schlichtherle.io.File.cp_p((File)realSource, (File)dest);
        } else {
            de.schlichtherle.io.File.cp_p((File)source, (File)dest);
        }
    }

    public void moveFile(de.schlichtherle.io.File source, de.schlichtherle.io.File dest) {
        de.schlichtherle.io.File file = new de.schlichtherle.io.File((File)source);
        de.schlichtherle.io.File tofile = new de.schlichtherle.io.File((File)dest);
        file.renameTo((File)tofile);
    }

    public void remove(Fileset oneFileSet, boolean verbose, Log logger) throws IOException {
        if (StringUtils.isBlank((String)oneFileSet.getDirectory())) {
            throw new IOException("FileSet's directory is required.");
        }
        de.schlichtherle.io.File directory = new de.schlichtherle.io.File(oneFileSet.getDirectory());
        if (!directory.isDirectory()) {
            throw new IOException("FileSet's directory: " + directory + " not found.");
        }
        TrueZipFileSetManager fileSetManager = new TrueZipFileSetManager(logger, verbose);
        fileSetManager.delete(oneFileSet, true);
    }
}

