/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.truezip;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:truezip-maven-plugin:1.0-beta-1", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Plugin for TrueZIP 1.0-beta-1", 0);
        this.append(sb, "Use this plugin create new or manipulate existing archives", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 5 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "copy".equals(this.goal)) {
            this.append(sb, "truezip:copy", 0);
            this.append(sb, "Copy a set of files in and out of an existing archive", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "files", 2);
                this.append(sb, "The list of FileItem to to manipulate the archive. Use this configuration when you have a need to do copying with option to change file name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileset", 2);
                this.append(sb, "A single FileSet to manipulate the archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "filesets", 2);
                this.append(sb, "The list of FileSet to manipulate the archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "Internal Maven's project", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose mode", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "truezip:help", 0);
            this.append(sb, "Display help information on truezip-maven-plugin. Call\n\u00a0\u00a0mvn\u00a0truezip:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "list".equals(this.goal)) {
            this.append(sb, "truezip:list", 0);
            this.append(sb, "List all files in the archive.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "fileset", 2);
                this.append(sb, "A single FileSet to manipulate the archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "filesets", 2);
                this.append(sb, "The list of FileSet to manipulate the archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputFile", 2);
                this.append(sb, "Write list output to a file if needed", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "Internal Maven's project", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose mode", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "move".equals(this.goal)) {
            this.append(sb, "truezip:move", 0);
            this.append(sb, "Rename a file in archive.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "from", 2);
                this.append(sb, "Path of original file", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "Internal Maven's project", 3);
                this.append(sb, "", 0);
                this.append(sb, "to", 2);
                this.append(sb, "Path of destination file", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "remove".equals(this.goal)) {
            this.append(sb, "truezip:remove", 0);
            this.append(sb, "Remove a set of files from an existing archive", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "fileset", 2);
                this.append(sb, "A single FileSet to manipulate the archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "filesets", 2);
                this.append(sb, "The list of FileSet to manipulate the archive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "Internal Maven's project", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose mode", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = this.toLines(description, indent).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private List toLines(String text, int indent) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            this.toLines(lines, ind + plainLines[i]);
        }
        return lines;
    }

    private void toLines(List lines, String line) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= this.lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * this.indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", this.indentSize - buf.length() % this.indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

