/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tidy;

import java.io.IOException;
import java.io.StringReader;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.tidy.Utils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.stax2.XMLInputFactory2;

@Mojo(name="pom", requiresProject=true, requiresDirectInvocation=true)
public class PomMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    private static final String[][] sequence = new String[][]{{"modelVersion", ""}, {"parent", "\n"}, {"groupId", "\n"}, {"artifactId", ""}, {"version", ""}, {"packaging", ""}, {"name", "\n"}, {"description", ""}, {"url", ""}, {"inceptionYear", ""}, {"organization", ""}, {"licenses", ""}, {"developers", "\n"}, {"contributors", ""}, {"mailingLists", "\n"}, {"prerequisites", "\n"}, {"modules", "\n"}, {"scm", "\n"}, {"issueManagement", ""}, {"ciManagement", ""}, {"distributionManagement", ""}, {"properties", "\n"}, {"repositories", "\n"}, {"pluginRepositories", ""}, {"dependencyManagement", "\n"}, {"dependencies", ""}, {"build", "\n"}, {"reporting", "\n"}, {"profiles", "\n"}};
    private static final String[][] buildSequence = new String[][]{{"defaultGoal", ""}, {"sourceDirectory", ""}, {"scriptSourceDirectory", ""}, {"testSourceDirectory", ""}, {"directory", ""}, {"outputDirectory", ""}, {"testOutputDirectory", ""}, {"finalName", ""}, {"filters", ""}, {"resources", ""}, {"testResources", ""}, {"pluginManagement", ""}, {"plugins", ""}, {"extensions", ""}};

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            StringBuilder input = Utils.readXmlFile(this.project.getFile());
            input = this.sortSections(input, "/project/build", buildSequence);
            input = this.sortSections(input, "/project", sequence);
            Utils.writeXmlFile(this.project.getFile(), input);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (XMLStreamException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private StringBuilder sortSections(StringBuilder input, String scope, String[][] sequence) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory2.newInstance();
        inputFactory.setProperty("org.codehaus.stax2.preserveLocation", Boolean.TRUE);
        String inputStr = input.toString();
        int first = Integer.MAX_VALUE;
        int last = Integer.MIN_VALUE;
        int outdent = -1;
        int[] starts = new int[sequence.length];
        int[] ends = new int[sequence.length];
        block0: for (int i = 0; i < sequence.length; ++i) {
            Pattern matchScopeRegex = Pattern.compile("\\Q" + scope + "\\E");
            Pattern matchTargetRegex = Pattern.compile("\\Q" + scope + "\\E/\\Q" + sequence[i][0] + "\\E");
            Stack<String> stack = new Stack<String>();
            String path = "";
            boolean inMatchScope = false;
            int start = -1;
            ends[i] = -1;
            starts[i] = -1;
            XMLEventReader pom = inputFactory.createXMLEventReader(new StringReader(inputStr));
            while (pom.hasNext()) {
                XMLEvent event = pom.nextEvent();
                if (event.isStartElement()) {
                    stack.push(path);
                    String elementName = event.asStartElement().getName().getLocalPart();
                    path = path + "/" + elementName;
                    if (matchScopeRegex.matcher(path).matches()) {
                        inMatchScope = true;
                        start = -1;
                    } else if (inMatchScope && matchTargetRegex.matcher(path).matches()) {
                        start = event.getLocation().getCharacterOffset();
                    }
                }
                if (!event.isEndElement()) continue;
                if (matchTargetRegex.matcher(path).matches() && start != -1) {
                    starts[i] = start;
                    ends[i] = pom.peek().getLocation().getCharacterOffset();
                    first = Math.min(first, starts[i]);
                    last = Math.max(last, ends[i]);
                    continue block0;
                }
                if (matchScopeRegex.matcher(path).matches()) {
                    if (outdent == -1) {
                        outdent = this.getIndent(input, start, event.getLocation().getCharacterOffset() - 1);
                    }
                    inMatchScope = false;
                    start = -1;
                }
                path = (String)stack.pop();
            }
        }
        int indentTotal = 0;
        int indentCount = 0;
        int lastEnd = 0;
        for (int i = 0; i < sequence.length; ++i) {
            if (starts[i] == -1) continue;
            int pos = starts[i] - 1;
            int indent = this.getIndent(input, lastEnd, pos);
            indentTotal += indent;
            ++indentCount;
        }
        this.getLog().debug((CharSequence)("Average indent: " + (indentCount == 0 ? 2 : indentTotal / indentCount)));
        String indent = StringUtils.repeat((String)" ", (int)(indentCount == 0 ? 2 : indentTotal / indentCount));
        if (first > last) {
            return input;
        }
        StringBuilder output = new StringBuilder(input.length() + 1024);
        output.append(inputStr.substring(0, first).trim());
        String lastSep = null;
        for (int i = 0; i < sequence.length; ++i) {
            if (lastSep == null || !StringUtils.isWhitespace((String)sequence[i][1]) || lastSep.length() < sequence[i][1].length()) {
                lastSep = sequence[i][1];
                output.append(lastSep);
            }
            if (starts[i] == -1) continue;
            int l = -1;
            for (int k = 0; k < sequence.length; ++k) {
                if (ends[k] == -1 || l != -1 && ends[l] >= ends[k] || ends[k] >= starts[i]) continue;
                l = k;
            }
            if (l != -1) {
                output.append(inputStr.substring(ends[l], starts[i]).trim());
                lastSep = null;
            }
            output.append("\n");
            output.append(indent);
            output.append(inputStr.substring(starts[i], ends[i]).trim());
        }
        output.append("\n");
        if (outdent > 0) {
            output.append(StringUtils.repeat((String)" ", (int)outdent));
        }
        output.append(inputStr.substring(last).trim());
        output.append("\n");
        return output;
    }

    private int getIndent(StringBuilder input, int lastEnd, int pos) {
        String posChar;
        int indent = 0;
        while (pos > lastEnd && StringUtils.isWhitespace((String)(posChar = input.substring(pos, pos + 1))) && !"\n".equals(posChar) && !"\r".equals(posChar)) {
            ++indent;
            --pos;
        }
        return indent;
    }
}

