/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.templating;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;

public abstract class AbstractFilterSourcesMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="maven.resources.escapeString")
    protected String escapeString;
    @Parameter
    protected List<String> delimiters;
    @Parameter(defaultValue="true")
    protected boolean useDefaultDelimiters;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Component(hint="default")
    private MavenResourcesFiltering mavenResourcesFiltering;

    protected abstract File getSourceDirectory();

    protected abstract File getOutputDirectory();

    public void execute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("source=" + this.getSourceDirectory() + " target=" + this.getOutputDirectory()));
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Resource resource = new Resource();
        resource.setFiltering(true);
        this.getLog().debug((CharSequence)this.getSourceDirectory().getAbsolutePath());
        resource.setDirectory(this.getSourceDirectory().getAbsolutePath());
        resources.add(resource);
        MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution(resources, this.getOutputDirectory(), this.project, this.encoding, Collections.emptyList(), Collections.emptyList(), this.session);
        mavenResourcesExecution.setInjectProjectBuildFilters(false);
        mavenResourcesExecution.setEscapeString(this.escapeString);
        if (this.delimiters != null && !this.delimiters.isEmpty()) {
            LinkedHashSet<String> delims = new LinkedHashSet<String>();
            if (this.useDefaultDelimiters) {
                delims.addAll(mavenResourcesExecution.getDelimiters());
            }
            for (String delim : this.delimiters) {
                if (delim == null) {
                    delims.add("${*}");
                    continue;
                }
                delims.add(delim);
            }
            mavenResourcesExecution.setDelimiters(delims);
        }
        try {
            this.mavenResourcesFiltering.filterResources(mavenResourcesExecution);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        this.addSourceFolderToProject(this.project);
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Source directory: " + this.getOutputDirectory() + " added."));
        }
    }

    protected abstract void addSourceFolderToProject(MavenProject var1);
}

