/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sysdeo.ide;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.sysdeo.ide.Messages;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class IdeUtils {
    private IdeUtils() {
    }

    public static String getCanonicalPath(File file) throws MojoExecutionException {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new MojoExecutionException(Messages.getString("cantcanonicalize", file.getAbsolutePath()), (Exception)e);
        }
    }

    public static String toRelativeAndFixSeparator(File basedir, File fileToAdd, boolean replaceSlashesWithDashes) throws MojoExecutionException {
        String basedirpath = IdeUtils.getCanonicalPath(basedir);
        String absolutePath = IdeUtils.getCanonicalPath(fileToAdd);
        String relative = absolutePath.equals(basedirpath) ? "." : (absolutePath.startsWith(basedirpath) ? absolutePath.substring(basedirpath.length() + 1) : absolutePath);
        relative = StringUtils.replace((String)relative, (char)'\\', (char)'/');
        if (replaceSlashesWithDashes) {
            relative = StringUtils.replace((String)relative, (char)'/', (char)'-');
            relative = StringUtils.replace((String)relative, (char)':', (char)'-');
        }
        return relative;
    }

    public static String getPluginSetting(MavenProject project, String artifactId, String optionName, String defaultValue) {
        Iterator it = project.getModel().getBuild().getPlugins().iterator();
        while (it.hasNext()) {
            Xpp3Dom o;
            Plugin plugin = (Plugin)it.next();
            if (!plugin.getArtifactId().equals(artifactId) || (o = (Xpp3Dom)plugin.getConfiguration()) == null || o.getChild(optionName) == null) continue;
            return o.getChild(optionName).getValue();
        }
        return defaultValue;
    }

    public static Artifact resolveArtifactWithClassifier(String groupId, String artifactId, String version, String classifier, ArtifactRepository localRepository, ArtifactResolver artifactResolver, ArtifactFactory artifactFactory, List remoteRepos, Log log) {
        String type = classifier;
        if ("sources".equals(type)) {
            type = "java-source";
        }
        Artifact resolvedArtifact = artifactFactory.createArtifactWithClassifier(groupId, artifactId, version, type, classifier);
        try {
            artifactResolver.resolve(resolvedArtifact, remoteRepos, localRepository);
        }
        catch (ArtifactNotFoundException e) {
        }
        catch (ArtifactResolutionException e) {
            String message = Messages.getString("errorresolving", new Object[]{classifier, resolvedArtifact.getId(), e.getMessage()});
            log.warn((CharSequence)message);
        }
        return resolvedArtifact;
    }

    public static String getDependencyVersion(String[] artifactNames, Set artifacts, int len) {
        Iterator itr = artifacts.iterator();
        while (itr.hasNext()) {
            Artifact artifact = (Artifact)itr.next();
            for (int j = 0; j < artifactNames.length; ++j) {
                String name = artifactNames[j];
                if (!name.equals(artifact.getArtifactId())) continue;
                return StringUtils.substring((String)artifact.getVersion(), (int)0, (int)len);
            }
        }
        return null;
    }
}

