/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sysdeo;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.sysdeo.ide.AbstractIdeSupportMojo;
import org.codehaus.mojo.sysdeo.ide.IdeDependency;
import org.codehaus.mojo.sysdeo.ide.IdeUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;

public class SysdeoMojo
extends AbstractIdeSupportMojo {
    private static final String TOMCAT_PLUGIN = ".tomcatplugin";
    private File warSourceDirectory;
    private File contextDefinition;
    private String webPath;
    private boolean useClasspathVariable;
    private List ignoreArtifact = new ArrayList();
    private String[] ignoredArtifacts;

    public SysdeoMojo() {
        this.ignoreArtifact.add("jsp-api");
        this.ignoreArtifact.add("el-api");
        this.ignoreArtifact.add("servlet-api");
        this.ignoreArtifact.add("gwt-user");
    }

    protected boolean getUseProjectReferences() {
        return true;
    }

    protected boolean setup() {
        if (this.ignoredArtifacts != null) {
            for (int i = 0; i < this.ignoredArtifacts.length; ++i) {
                this.ignoreArtifact.add(this.ignoredArtifacts[i]);
            }
        }
        if (!this.getProject().getPackaging().equals("war")) {
            this.getLog().info((CharSequence)"Not executing sysdeo-tomcat plugin, this is project is not a war package");
            return false;
        }
        return true;
    }

    protected void writeConfiguration(IdeDependency[] dependencies) throws MojoExecutionException {
        File webclasspath = new File(this.warSourceDirectory, ".#webclasspath");
        if (webclasspath.exists()) {
            webclasspath.delete();
        }
        File projectDir = this.getProject().getBasedir();
        this.forceTomcatNature(projectDir);
        ArrayList<IdeDependency> referencedProjects = new ArrayList<IdeDependency>();
        ArrayList<IdeDependency> jarDependencies = new ArrayList<IdeDependency>();
        ArrayList<String> systemDependencyPaths = new ArrayList<String>();
        IdeDependency thisDependency = new IdeDependency();
        thisDependency.setArtifactId(this.getProject().getArtifactId());
        thisDependency.setOutputDirectory(this.getOutputDirectory());
        referencedProjects.add(thisDependency);
        for (int i = 0; i < dependencies.length; ++i) {
            IdeDependency dependency = dependencies[i];
            if (dependency.isProvided() || dependency.isTestDependency()) continue;
            if (dependency.isReferencedProject() || this.getWorkspaceProjects().contains(dependency)) {
                referencedProjects.add(dependency);
                continue;
            }
            if (dependency.isSystemScoped()) {
                String absolutePath = dependency.getFile().getAbsolutePath();
                String osName = System.getProperty("os.name");
                if (osName.toUpperCase().indexOf("WINDOWS") >= 0) {
                    absolutePath = absolutePath.substring(0, 1).toUpperCase() + absolutePath.substring(1);
                    absolutePath = absolutePath.replace('\\', '/');
                }
                systemDependencyPaths.add(absolutePath);
                continue;
            }
            if (!dependency.getType().equalsIgnoreCase("jar") || this.ignoreArtifact.contains(dependency.getArtifactId())) continue;
            jarDependencies.add(dependency);
        }
        String extraContext = "";
        try {
            String contextString = FileUtils.readFileToString((File)this.contextDefinition, (String)"UTF-8");
            int context = contextString.indexOf("Context");
            int start = contextString.indexOf(">", context);
            int stop = contextString.indexOf("</Context>");
            extraContext = contextString.substring(start + 1, stop);
            extraContext = URLEncoder.encode(extraContext);
        }
        catch (Exception e) {
            this.getLog().info((CharSequence)("No valid context file found at: " + this.contextDefinition));
        }
        Configuration cfg = new Configuration();
        cfg.setClassForTemplateLoading(SysdeoMojo.class, "");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("referencedProjects", referencedProjects);
        context.put("jarDependencies", jarDependencies);
        context.put("systemDependencyPaths", systemDependencyPaths);
        context.put("webPath", this.webPath);
        context.put("localRepository", this.useClasspathVariable ? "M2_REPO" : this.getLocalRepository().getBasedir());
        context.put("warSourceDir", IdeUtils.toRelativeAndFixSeparator(this.getProject().getBasedir(), this.getWarSourceDirectory(), false));
        context.put("extraContext", extraContext);
        File tomcatPluginFile = new File(projectDir, TOMCAT_PLUGIN);
        try {
            FileWriter configWriter = new FileWriter(tomcatPluginFile);
            Template template = cfg.getTemplate("tomcatplugin.fm");
            template.process(context, (Writer)configWriter);
            ((Writer)configWriter).flush();
            ((Writer)configWriter).close();
            this.getLog().info((CharSequence)("Write tomcat plugin file to: " + tomcatPluginFile.getAbsolutePath()));
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to write tomcat plugin config file", (Exception)ioe);
        }
        catch (TemplateException te) {
            throw new MojoExecutionException("Unable to merge freemarker template", (Exception)((Object)te));
        }
    }

    protected void forceTomcatNature(File projectDir) {
        try {
            File dotProject = new File(projectDir, ".project");
            String content = FileUtils.readFileToString((File)dotProject, null);
            if (content.indexOf("<nature>com.sysdeo.eclipse.tomcat.tomcatnature</nature>") < 0) {
                this.getLog().info((CharSequence)"Add tomcat nature to the eclipse .project file");
                try {
                    Xpp3Dom dom = Xpp3DomBuilder.build((Reader)new FileReader(dotProject));
                    Xpp3Dom nature = new Xpp3Dom("nature");
                    nature.setValue("com.sysdeo.eclipse.tomcat.tomcatnature");
                    dom.getChild("natures").addChild(nature);
                    FileWriter writer = new FileWriter(dotProject);
                    Xpp3DomWriter.write((Writer)writer, (Xpp3Dom)dom);
                    writer.close();
                }
                catch (Exception e) {
                    this.getLog().warn((CharSequence)"Failed to add missing tomcat nature to the eclipse .project file", (Throwable)e);
                }
            }
            File dotClassPath = new File(projectDir, ".classpath");
            FileUtils.touch((File)dotClassPath);
        }
        catch (IOException e) {
            this.getLog().info((CharSequence)"Failed to retrieve the Eclipse .project file");
        }
    }

    protected String getOutputDirectory() {
        String relative = this.getProject().getFile().getParent();
        String buildOutputDirectory = this.getProject().getBuild().getOutputDirectory();
        return buildOutputDirectory.substring(relative.length() + 1).replace('\\', '/');
    }

    public File getContextDefinition() {
        return this.contextDefinition;
    }

    public void setContextDefinition(File contextDefinition) {
        this.contextDefinition = contextDefinition;
    }

    public File getWarSourceDirectory() {
        return this.warSourceDirectory;
    }

    public void setWarSourceDirectory(File warSourceDirectory) {
        this.warSourceDirectory = warSourceDirectory;
    }

    public void setUseClasspathVariable(boolean useClasspathVariable) {
        this.useClasspathVariable = useClasspathVariable;
    }
}

