/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sysdeo;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.sysdeo.ide.AbstractIdeSupportMojo;
import org.codehaus.mojo.sysdeo.ide.IdeDependency;
import org.codehaus.mojo.sysdeo.ide.IdeUtils;

public class SysdeoMojo
extends AbstractIdeSupportMojo {
    private static String TOMCAT_PLUGIN = ".tomcatplugin";
    private File warSourceDirectory;
    private File contextDefinition;
    private List ignoreArtifact = new ArrayList();
    static /* synthetic */ Class class$org$codehaus$mojo$sysdeo$SysdeoMojo;

    public SysdeoMojo() {
        this.ignoreArtifact.add("jsp-api");
        this.ignoreArtifact.add("servlet-api");
    }

    protected boolean getUseProjectReferences() {
        return true;
    }

    protected boolean setup() throws MojoExecutionException {
        return true;
    }

    protected void writeConfiguration(IdeDependency[] dependencies) throws MojoExecutionException {
        if (!this.getProject().getPackaging().equals("war")) {
            this.getLog().info((CharSequence)"Not executing sysdeo-tomcat plugin, this is project is not a war package");
            return;
        }
        File projectDir = this.getProject().getBasedir();
        ArrayList<IdeDependency> referencedProjects = new ArrayList<IdeDependency>();
        ArrayList<IdeDependency> jarDependencies = new ArrayList<IdeDependency>();
        ArrayList<String> systemDependencyPaths = new ArrayList<String>();
        IdeDependency thisDependency = new IdeDependency();
        thisDependency.setArtifactId(this.getProject().getArtifactId());
        referencedProjects.add(thisDependency);
        for (int i = 0; i < dependencies.length; ++i) {
            IdeDependency dependency = dependencies[i];
            if (dependency.isProvided() || dependency.isTestDependency()) continue;
            if (dependency.isReferencedProject()) {
                referencedProjects.add(dependency);
                continue;
            }
            if (dependency.isSystemScoped()) {
                String absolutePath = dependency.getFile().getAbsolutePath();
                String osName = System.getProperty("os.name");
                if (osName.toUpperCase().contains("WINDOWS")) {
                    absolutePath = absolutePath.substring(0, 1).toUpperCase() + absolutePath.substring(1);
                    absolutePath = absolutePath.replace('\\', '/');
                }
                systemDependencyPaths.add(absolutePath);
                continue;
            }
            if (!dependency.getType().equalsIgnoreCase("jar") || this.ignoreArtifact.contains(dependency.getArtifactId())) continue;
            jarDependencies.add(dependency);
        }
        String extraContext = "";
        try {
            String contextString = FileUtils.readFileToString((File)this.contextDefinition, (String)"UTF-8");
            int context = contextString.indexOf("Context");
            int start = contextString.indexOf(">", context);
            int stop = contextString.indexOf("</Context>");
            extraContext = contextString.substring(start + 1, stop);
            extraContext = URLEncoder.encode(extraContext);
        }
        catch (Exception e) {
            this.getLog().info((CharSequence)("No valid context file found at: " + this.contextDefinition));
        }
        Configuration cfg = new Configuration();
        cfg.setClassForTemplateLoading(class$org$codehaus$mojo$sysdeo$SysdeoMojo == null ? (class$org$codehaus$mojo$sysdeo$SysdeoMojo = SysdeoMojo.class$("org.codehaus.mojo.sysdeo.SysdeoMojo")) : class$org$codehaus$mojo$sysdeo$SysdeoMojo, "");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("referencedProjects", referencedProjects);
        context.put("jarDependencies", jarDependencies);
        context.put("systemDependencyPaths", systemDependencyPaths);
        context.put("finalName", this.getProject().getBuild().getFinalName());
        context.put("warSourceDir", IdeUtils.toRelativeAndFixSeparator(this.getProject().getBasedir(), this.getWarSourceDirectory(), false));
        context.put("extraContext", extraContext);
        File tomcatPluginFile = new File(projectDir, TOMCAT_PLUGIN);
        try {
            FileWriter configWriter = new FileWriter(tomcatPluginFile);
            Template template = cfg.getTemplate("tomcatplugin.fm");
            template.process(context, (Writer)configWriter);
            ((Writer)configWriter).flush();
            ((Writer)configWriter).close();
            this.getLog().info((CharSequence)("Write tomcat plugin file to: " + tomcatPluginFile.getAbsolutePath()));
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to write tomcat plugin config file", (Exception)ioe);
        }
        catch (TemplateException te) {
            throw new MojoExecutionException("Unable to merge freemarker template", (Exception)((Object)te));
        }
    }

    public File getContextDefinition() {
        return this.contextDefinition;
    }

    public void setContextDefinition(File contextDefinition) {
        this.contextDefinition = contextDefinition;
    }

    public File getWarSourceDirectory() {
        return this.warSourceDirectory;
    }

    public void setWarSourceDirectory(File warSourceDirectory) {
        this.warSourceDirectory = warSourceDirectory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

