/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sql;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.mojo.sql.Fileset;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class SqlExecMojo
extends AbstractMojo {
    public static final String ON_ERROR_ABORT = "abort";
    public static final String ON_ERROR_CONTINUE = "continue";
    public static final String FILE_SORTING_ASC = "ascending";
    public static final String FILE_SORTING_DSC = "descending";
    private String username;
    private String password;
    private String driverProperties;
    private Settings settings;
    private String settingsKey;
    private boolean skipOnConnectionError;
    private String sqlCommand = "";
    private File[] srcFiles;
    private Fileset fileset;
    private boolean skip;
    private String url;
    private String driver;
    private boolean autocommit;
    private String onError = "abort";
    private String delimiter = ";";
    private String delimiterType = "normal";
    private String orderFile = null;
    private boolean enableBlockMode = false;
    private boolean keepFormat = false;
    private boolean printResultSet = false;
    private boolean showheaders = true;
    private File outputFile;
    private String encoding = "";
    private boolean append = false;
    private boolean escapeProcessing = true;
    private int successfulStatements = 0;
    private int totalStatements = 0;
    private Connection conn = null;
    private Statement statement = null;
    private Vector transactions = new Vector();

    public Transaction createTransaction() {
        Transaction t = new Transaction();
        this.transactions.addElement(t);
        return t;
    }

    public void addText(String sql) {
        this.sqlCommand = this.sqlCommand + sql;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setDelimiterType(String delimiterType) {
        this.delimiterType = delimiterType;
    }

    public void setPrintResutlSet(boolean print) {
        this.printResultSet = print;
    }

    public void setShowheaders(boolean showheaders) {
        this.showheaders = showheaders;
    }

    public void setOutputFile(File output) {
        this.outputFile = output;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setKeepFormat(boolean keepformat) {
        this.keepFormat = keepformat;
    }

    public void setEscapeProcessing(boolean enable) {
        this.escapeProcessing = enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip sql execution");
            return;
        }
        this.successfulStatements = 0;
        this.totalStatements = 0;
        this.loadUserInfoFromSettings();
        this.addCommandToTransactions();
        this.addFilesToTransactions();
        this.addFileSetToTransactions();
        this.sortTransactions();
        try {
            this.conn = this.getConnection();
        }
        catch (SQLException e) {
            if (this.skipOnConnectionError) return;
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        try {
            try {
                this.statement = this.conn.createStatement();
                this.statement.setEscapeProcessing(this.escapeProcessing);
                PrintStream out = System.out;
                try {
                    if (this.outputFile != null) {
                        this.getLog().debug((CharSequence)("Opening PrintStream to output file " + this.outputFile));
                        out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.outputFile.getAbsolutePath(), this.append)));
                    }
                    Enumeration e = this.transactions.elements();
                    while (e.hasMoreElements()) {
                        Transaction t = (Transaction)e.nextElement();
                        t.runTransaction(out);
                        if (this.autocommit) continue;
                        this.getLog().debug((CharSequence)"Committing transaction");
                        this.conn.commit();
                    }
                    Object var5_8 = null;
                    if (out != null && out != System.out) {
                        out.close();
                    }
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    if (out == null) throw throwable;
                    if (out == System.out) throw throwable;
                    out.close();
                    throw throwable;
                }
                Object var7_11 = null;
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            catch (SQLException e) {
                if (this.autocommit) throw new MojoExecutionException(e.getMessage(), (Exception)e);
                if (this.conn == null) throw new MojoExecutionException(e.getMessage(), (Exception)e);
                if (!ON_ERROR_ABORT.equalsIgnoreCase(this.getOnError())) throw new MojoExecutionException(e.getMessage(), (Exception)e);
                try {
                    this.conn.rollback();
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
                if (this.conn == null) throw throwable;
                this.conn.close();
                throw throwable;
            }
            catch (SQLException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException ex) {}
        if (this.statement != null) {
            this.statement.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
        this.getLog().info((CharSequence)(this.getSuccessfulStatements() + " of " + this.getTotalStatements() + " SQL statements executed successfully"));
    }

    private void addCommandToTransactions() {
        this.createTransaction().addText(this.sqlCommand.trim());
    }

    private void addFileSetToTransactions() {
        String[] includedFiles;
        if (this.fileset != null) {
            this.fileset.scan();
            includedFiles = this.fileset.getIncludedFiles();
        } else {
            includedFiles = new String[]{};
        }
        for (int j = 0; j < includedFiles.length; ++j) {
            this.createTransaction().setSrc(new File(this.fileset.getBasedir(), includedFiles[j]));
        }
    }

    private void addFilesToTransactions() throws MojoExecutionException {
        File[] files = this.getSrcFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            if (files[i] != null && !files[i].exists()) {
                throw new MojoExecutionException(files[i].getPath() + " not found.");
            }
            this.createTransaction().setSrc(files[i]);
        }
    }

    private void sortTransactions() {
        if (FILE_SORTING_ASC.equalsIgnoreCase(this.orderFile)) {
            Collections.sort(this.transactions);
        } else if (FILE_SORTING_DSC.equalsIgnoreCase(this.orderFile)) {
            Collections.sort(this.transactions, Collections.reverseOrder());
        }
    }

    private void loadUserInfoFromSettings() throws MojoExecutionException {
        Server server;
        if (this.settingsKey == null) {
            this.settingsKey = this.getUrl();
        }
        if ((this.getUsername() == null || this.getPassword() == null) && this.settings != null && (server = this.settings.getServer(this.settingsKey)) != null) {
            if (this.getUsername() == null) {
                this.setUsername(server.getUsername());
            }
            if (this.getPassword() == null) {
                this.setPassword(server.getPassword());
            }
        }
        if (this.getUsername() == null) {
            this.setUsername("");
        }
        if (this.getPassword() == null) {
            this.setPassword("");
        }
    }

    private Connection getConnection() throws MojoExecutionException, SQLException {
        this.getLog().debug((CharSequence)("connecting to " + this.getUrl()));
        Properties info = new Properties();
        info.put("user", this.getUsername());
        info.put("password", this.getPassword());
        info.putAll((Map<?, ?>)this.getDriverProperties());
        Driver driverInstance = null;
        try {
            Class<?> dc = Class.forName(this.getDriver());
            driverInstance = (Driver)dc.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Driver class not found: " + this.getDriver(), (Exception)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failure loading driver: " + this.getDriver(), e);
        }
        Connection conn = driverInstance.connect(this.getUrl(), info);
        if (conn == null) {
            throw new SQLException("No suitable Driver for " + this.getUrl());
        }
        conn.setAutoCommit(this.autocommit);
        return conn;
    }

    protected Properties getDriverProperties() throws MojoExecutionException {
        Properties properties = new Properties();
        if (!StringUtils.isEmpty((String)this.driverProperties)) {
            String[] tokens = StringUtils.split((String)this.driverProperties, (String)",");
            for (int i = 0; i < tokens.length; ++i) {
                String[] keyValueTokens = StringUtils.split((String)tokens[i].trim(), (String)"=");
                if (keyValueTokens.length != 2) {
                    throw new MojoExecutionException("Invalid JDBC Driver properties: " + this.driverProperties);
                }
                properties.setProperty(keyValueTokens[0], keyValueTokens[1]);
            }
        }
        return properties;
    }

    private void runStatements(Reader reader, PrintStream out) throws SQLException, IOException {
        String line;
        if (this.enableBlockMode) {
            String line2 = IOUtil.toString((Reader)reader);
            this.execSQL(line2, out);
            return;
        }
        StringBuffer sql = new StringBuffer();
        BufferedReader in = new BufferedReader(reader);
        while ((line = in.readLine()) != null) {
            String token;
            StringTokenizer st;
            if (!this.keepFormat) {
                line = line.trim();
            }
            if (!this.keepFormat && (line.startsWith("//") || line.startsWith("--") || (st = new StringTokenizer(line)).hasMoreTokens() && "REM".equalsIgnoreCase(token = st.nextToken()))) continue;
            if (!this.keepFormat) {
                sql.append(" ").append(line);
            } else {
                sql.append("\n").append(line);
            }
            if (!this.keepFormat && line.indexOf("--") >= 0) {
                sql.append("\n");
            }
            if ((!this.delimiterType.equals("normal") || !sql.toString().endsWith(this.delimiter)) && (!this.delimiterType.equals("row") || !line.trim().equals(this.delimiter))) continue;
            this.execSQL(sql.substring(0, sql.length() - this.delimiter.length()), out);
            sql.replace(0, sql.length(), "");
        }
        if (!sql.equals("")) {
            this.execSQL(sql.toString(), out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execSQL(String sql, PrintStream out) throws SQLException {
        if ("".equals(sql.trim())) {
            return;
        }
        ResultSet resultSet = null;
        try {
            ++this.totalStatements;
            this.getLog().debug((CharSequence)("SQL: " + sql));
            int updateCountTotal = 0;
            boolean ret = this.statement.execute(sql);
            int updateCount = this.statement.getUpdateCount();
            resultSet = this.statement.getResultSet();
            do {
                if (!ret) {
                    if (updateCount != -1) {
                        updateCountTotal += updateCount;
                    }
                } else if (this.printResultSet) {
                    this.printResultSet(resultSet, out);
                }
                if (!(ret = this.statement.getMoreResults())) continue;
                updateCount = this.statement.getUpdateCount();
                resultSet = this.statement.getResultSet();
            } while (ret);
            this.getLog().debug((CharSequence)(updateCountTotal + " rows affected"));
            if (this.printResultSet) {
                StringBuffer line = new StringBuffer();
                line.append(updateCountTotal).append(" rows affected");
                out.println(line);
            }
            for (SQLWarning warning = this.conn.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                this.getLog().debug((CharSequence)(warning + " sql warning"));
            }
            this.conn.clearWarnings();
            ++this.successfulStatements;
        }
        catch (SQLException e) {
            this.getLog().error((CharSequence)("Failed to execute: " + sql));
            if (!ON_ERROR_CONTINUE.equalsIgnoreCase(this.getOnError())) {
                throw e;
            }
            this.getLog().error((CharSequence)e.toString());
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    private void printResultSet(ResultSet rs, PrintStream out) throws SQLException {
        if (rs != null) {
            this.getLog().debug((CharSequence)"Processing new result set.");
            ResultSetMetaData md = rs.getMetaData();
            int columnCount = md.getColumnCount();
            StringBuffer line = new StringBuffer();
            if (this.showheaders) {
                for (int col = 1; col < columnCount; ++col) {
                    line.append(md.getColumnName(col));
                    line.append(",");
                }
                line.append(md.getColumnName(columnCount));
                out.println(line);
                line = new StringBuffer();
            }
            while (rs.next()) {
                boolean first = true;
                for (int col = 1; col <= columnCount; ++col) {
                    String columnValue = rs.getString(col);
                    if (columnValue != null) {
                        columnValue = columnValue.trim();
                    }
                    if (first) {
                        first = false;
                    } else {
                        line.append(",");
                    }
                    line.append(columnValue);
                }
                out.println(line);
                line = new StringBuffer();
            }
        }
        out.println();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    void setAutocommit(boolean autocommit) {
        this.autocommit = autocommit;
    }

    void setFileset(Fileset fileset) {
        this.fileset = fileset;
    }

    public File[] getSrcFiles() {
        return this.srcFiles;
    }

    public void setSrcFiles(File[] files) {
        this.srcFiles = files;
    }

    public String getOrderFile() {
        return this.orderFile;
    }

    public void setOrderFile(String orderFile) {
        if (FILE_SORTING_ASC.equalsIgnoreCase(orderFile)) {
            this.orderFile = FILE_SORTING_ASC;
        } else if (FILE_SORTING_DSC.equalsIgnoreCase(orderFile)) {
            this.orderFile = FILE_SORTING_DSC;
        } else {
            throw new IllegalArgumentException(orderFile + " is not a valid value for orderFile, only '" + FILE_SORTING_ASC + "' or '" + FILE_SORTING_DSC + "'.");
        }
    }

    int getGoodSqls() {
        return this.getSuccessfulStatements();
    }

    public int getSuccessfulStatements() {
        return this.successfulStatements;
    }

    public int getTotalStatements() {
        return this.totalStatements;
    }

    public String getOnError() {
        return this.onError;
    }

    public void setOnError(String action) {
        if (ON_ERROR_ABORT.equalsIgnoreCase(action)) {
            this.onError = ON_ERROR_ABORT;
        } else if (ON_ERROR_CONTINUE.equalsIgnoreCase(action)) {
            this.onError = ON_ERROR_CONTINUE;
        } else {
            throw new IllegalArgumentException(action + " is not a valid value for onError, only '" + ON_ERROR_ABORT + "' or '" + ON_ERROR_CONTINUE + "'.");
        }
    }

    void setSettings(Settings settings) {
        this.settings = settings;
    }

    void setSettingsKey(String key) {
        this.settingsKey = key;
    }

    void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setDriverProperties(String driverProperties) {
        this.driverProperties = driverProperties;
    }

    public boolean isEnableBlockMode() {
        return this.enableBlockMode;
    }

    public void setEnableBlockMode(boolean enableBlockMode) {
        this.enableBlockMode = enableBlockMode;
    }

    public String getSqlCommand() {
        return this.sqlCommand;
    }

    public void setSqlCommand(String sqlCommand) {
        this.sqlCommand = sqlCommand;
    }

    public Vector getTransactions() {
        return this.transactions;
    }

    public void setTransactions(Vector transactions) {
        this.transactions = transactions;
    }

    private class Transaction
    implements Comparable {
        private File tSrcFile = null;
        private String tSqlCommand = "";

        private Transaction() {
        }

        public void setSrc(File src) {
            this.tSrcFile = src;
        }

        public void addText(String sql) {
            this.tSqlCommand = this.tSqlCommand + sql;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runTransaction(PrintStream out) throws IOException, SQLException {
            if (this.tSqlCommand.length() != 0) {
                SqlExecMojo.this.getLog().info((CharSequence)"Executing commands");
                SqlExecMojo.this.runStatements(new StringReader(this.tSqlCommand), out);
            }
            if (this.tSrcFile != null) {
                SqlExecMojo.this.getLog().info((CharSequence)("Executing file: " + this.tSrcFile.getAbsolutePath()));
                InputStreamReader reader = null;
                reader = StringUtils.isEmpty((String)SqlExecMojo.this.encoding) ? new FileReader(this.tSrcFile) : new InputStreamReader((InputStream)new FileInputStream(this.tSrcFile), SqlExecMojo.this.encoding);
                try {
                    SqlExecMojo.this.runStatements(reader, out);
                }
                finally {
                    ((Reader)reader).close();
                }
            }
        }

        public int compareTo(Object object) {
            Transaction transaction = (Transaction)object;
            if (transaction.tSrcFile == null) {
                if (this.tSrcFile == null) {
                    return 0;
                }
                return Integer.MAX_VALUE;
            }
            if (this.tSrcFile == null) {
                return Integer.MIN_VALUE;
            }
            return this.tSrcFile.compareTo(transaction.tSrcFile);
        }
    }
}

