/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sonar;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.sonar.HttpsTrust;
import org.codehaus.plexus.util.IOUtil;

public class ServerMetadata {
    public static final int CONNECT_TIMEOUT_MILLISECONDS = 30000;
    public static final int READ_TIMEOUT_MILLISECONDS = 60000;
    private String url;
    private String version;

    public ServerMetadata(String url) {
        this.url = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    public String getVersion() {
        if (this.version == null) {
            try {
                this.version = this.remoteContent("/api/server/version");
            }
            catch (IOException e) {
                throw new IllegalStateException("SonarQube server can not be reached at " + this.url + ". Please check the parameter 'sonar.host.url'.", e);
            }
        }
        return this.version;
    }

    public String getUrl() {
        return this.url;
    }

    public void logSettings(Log log) {
        log.info((CharSequence)("SonarQube version: " + this.getVersion()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String remoteContent(String path) throws IOException {
        String fullUrl = this.url + path;
        HttpURLConnection conn = ServerMetadata.getConnection(fullUrl, "GET");
        InputStream input = (InputStream)conn.getContent();
        try {
            int statusCode = conn.getResponseCode();
            if (statusCode != 200) {
                throw new IOException("Status returned by url : '" + fullUrl + "' is invalid : " + statusCode);
            }
            String string = IOUtil.toString((InputStream)input);
            return string;
        }
        finally {
            IOUtil.close((InputStream)input);
            conn.disconnect();
        }
    }

    static HttpURLConnection getConnection(String url, String method) throws IOException {
        URL page = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)page.openConnection();
        HttpsTrust.INSTANCE.trust(conn);
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(60000);
        conn.setRequestMethod(method);
        conn.connect();
        return conn;
    }

    public boolean supportsMaven3() {
        return !ServerMetadata.isVersionPriorTo2Dot4(this.getVersion());
    }

    public boolean supportsMaven3_1() {
        return !ServerMetadata.isVersionPriorTo3Dot7(this.getVersion());
    }

    public boolean supportsSonarQubeRunnerBootstrappingFromMaven() {
        return !ServerMetadata.isVersionPriorTo4Dot3(this.getVersion());
    }

    public boolean supportsFilesAsSources() {
        return !ServerMetadata.isVersionPriorTo4Dot5(this.getVersion());
    }

    public static boolean isVersionPriorTo2Dot4(String version) {
        DefaultArtifactVersion artifactVersion = new DefaultArtifactVersion(version);
        return artifactVersion.getMajorVersion() < 2 || artifactVersion.getMajorVersion() == 2 && artifactVersion.getMinorVersion() < 4;
    }

    public static boolean isVersionPriorTo3Dot7(String version) {
        DefaultArtifactVersion artifactVersion = new DefaultArtifactVersion(version);
        return artifactVersion.getMajorVersion() < 3 || artifactVersion.getMajorVersion() == 3 && artifactVersion.getMinorVersion() < 7;
    }

    public static boolean isVersionPriorTo4Dot3(String version) {
        DefaultArtifactVersion artifactVersion = new DefaultArtifactVersion(version);
        return artifactVersion.getMajorVersion() < 4 || artifactVersion.getMajorVersion() == 4 && artifactVersion.getMinorVersion() < 3;
    }

    public static boolean isVersionPriorTo4Dot5(String version) {
        DefaultArtifactVersion artifactVersion = new DefaultArtifactVersion(version);
        return artifactVersion.getMajorVersion() < 4 || artifactVersion.getMajorVersion() == 4 && artifactVersion.getMinorVersion() < 5;
    }
}

