/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sonar;

import java.io.IOException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.sonar.Bootstraper;
import org.codehaus.mojo.sonar.MavenPluginManagerHelper;
import org.codehaus.mojo.sonar.ServerMetadata;

public class SonarMojo
extends AbstractMojo {
    protected MavenProject project;
    private MavenSession session;
    private String sonarHostURL;
    protected MavenPluginManager mavenPluginManager;
    protected MavenPluginManagerHelper mavenPluginManagerHelper;
    protected ArtifactRepository localRepository;
    private RuntimeInformation runtimeInformation;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            ServerMetadata server = new ServerMetadata(this.sonarHostURL);
            server.logSettings(this.getLog());
            ArtifactVersion mavenVersion = this.runtimeInformation.getApplicationVersion();
            this.checkVersionRequirements(server, mavenVersion);
            new Bootstraper(server, this.mavenPluginManager, this.mavenPluginManagerHelper).start(this.project, this.session);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to execute SonarQube analysis", (Exception)e);
        }
    }

    void checkVersionRequirements(ServerMetadata server, ArtifactVersion mavenVersion) throws IOException, MojoExecutionException {
        if (!server.supportsMaven3()) {
            throw new MojoExecutionException("SonarQube " + server.getVersion() + " does not support Maven 3");
        }
        if ((mavenVersion.getMajorVersion() > 3 || mavenVersion.getMajorVersion() == 3 && mavenVersion.getMinorVersion() >= 1) && !server.supportsMaven3_1()) {
            throw new MojoExecutionException("SonarQube " + server.getVersion() + " does not support Maven 3.1+. Please upgrade to SonarQube 3.7 or greater.");
        }
    }

    void setSonarHostURL(String sonarHostURL) {
        this.sonarHostURL = sonarHostURL;
    }
}

