/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.siteskinner;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;

public class ScmCommandExecutor {
    private ScmManager manager;
    private String connectionUrl;
    private Log log;

    public ScmCommandExecutor(ScmManager manager, String connectionUrl, Log log) {
        this.manager = manager;
        this.connectionUrl = connectionUrl;
        this.log = log;
    }

    public void checkout(String targetDirectory) throws ScmException {
        this.checkout(targetDirectory, null, null);
    }

    public void checkout(String targetDirectory, String includes, String excludes) throws ScmException {
        try {
            ScmRepository repository = this.manager.makeScmRepository(this.connectionUrl);
            ScmProvider provider = this.manager.getProviderByRepository(repository);
            ScmFileSet fileSet = this.getFileSet(targetDirectory, includes, excludes);
            CheckOutScmResult result = provider.checkOut(repository, fileSet);
            if (!this.checkResult((ScmResult)result)) {
                throw new ScmException("checkout failed with provider message");
            }
        }
        catch (Exception ex) {
            throw new ScmException("checkout failed.", (Throwable)ex);
        }
    }

    public void update(String targetDirectory) throws ScmException {
        this.update(targetDirectory, null, null);
    }

    public void update(String targetDirectory, String includes, String excludes) throws ScmException {
        try {
            ScmRepository repository = this.manager.makeScmRepository(this.connectionUrl);
            ScmProvider provider = this.manager.getProviderByRepository(repository);
            ScmFileSet fileSet = this.getFileSet(targetDirectory, includes, excludes);
            UpdateScmResult result = provider.update(repository, fileSet);
            if (!this.checkResult((ScmResult)result)) {
                throw new ScmException("checkout failed with provider message");
            }
        }
        catch (Exception ex) {
            throw new ScmException("checkout failed.", (Throwable)ex);
        }
    }

    private ScmFileSet getFileSet(String path, String includes, String excludes) throws IOException {
        File dir = new File(path);
        if (includes != null || excludes != null) {
            return new ScmFileSet(dir, includes, excludes);
        }
        return new ScmFileSet(dir);
    }

    private boolean checkResult(ScmResult result) {
        if (!result.isSuccess()) {
            this.log.warn((CharSequence)"Provider message:");
            this.log.warn((CharSequence)(result.getProviderMessage() == null ? "" : result.getProviderMessage()));
            this.log.warn((CharSequence)"Command output:");
            this.log.warn((CharSequence)(result.getCommandOutput() == null ? "" : result.getCommandOutput()));
            return false;
        }
        return true;
    }
}

